package com.thebeastshop.pegasus.component.redenvelope.business;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.redenvelope.condition.RedEnvelopeCondition;
import com.thebeastshop.pegasus.component.support.Res;
import com.thebeastshop.support.vo.redenvelope.ReceiveDetailsVO;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;

/**
 * 红包分享业务接口
 * Created by feilong.gao on 2016/12/20.
 */
public interface IRedEnvelopeShareService {

    /**
     * 抽取分享红包
     *
     * @param member
     * @param condition
     */
    public Res<ReceiveDetailsVO> receiveRedEnvelope(MemberVO member, RedEnvelopeCondition condition);


    /**
     * 创建红包活动
     *
     * @return
     */
    public Res<Long> createRedEnvelopeActivity(RedEnvelopeConfig config, MemberVO member, String bindId);

}
