package com.thebeastshop.pegasus.component.product.enums;

import com.thebeastshop.support.mark.HasIdGetter.HasIntIdGetter;
import com.thebeastshop.support.mark.HasName;

/**
 * 商品排序字段
 * 
 * @author Paul-xiong
 *
 */
public enum ProductSortField implements HasIntIdGetter, HasName {

	/**
	 * 上架时间
	 */
	RELEASE(0, "create_time"),
	/**
	 * 价格
	 */
	PRICE(1, "price"),;

	public final Integer id;
	public final String name;

	ProductSortField(final Integer id, final String name) {
		this.id = id;
		this.name = name;
	}

	@Override
	public Integer getId() {
		return id;
	}

	@Override
	public String getName() {
		return name;
	}
}
