package com.thebeastshop.pegasus.component.price;

import java.math.BigDecimal;

import java.util.Map;
import java.util.Map.Entry;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.support.util.PriceUtil;

/**
 * 计价器工具
 * 
 * @author Paul-xiong
 *
 */
public class PriceCalculatorUtil {

	/**
	 * 计算总价。
	 *
	 * @param priceMap
	 * @return
	 */
	public static BigDecimal sumAllPrice(final Map<ProductPack, BigDecimal> priceMap) {
		BigDecimal allPrice = BigDecimal.ZERO;
		for (final Entry<ProductPack, BigDecimal> entry : priceMap.entrySet()) {
			allPrice = allPrice.add(entry.getValue().multiply(BigDecimal.valueOf(entry.getKey().getCount())));
		}
		return PriceUtil.keepToCent(allPrice);
	}

	/**
	 * 分摊省下来的钱
	 *
	 * @param savedPrice
	 *            省下来的总钱数
	 * @param priceMap
	 *            分摊前的价格映射关系
	 * @return 分摊完之后的价格映射关系
	 */
	public static Map<ProductPack, BigDecimal> shareDiscount(final BigDecimal savedPrice,
			final Map<ProductPack, BigDecimal> priceMap) {
		if (savedPrice.compareTo(BigDecimal.ZERO) == 0) {
			return priceMap;
		}
		return PriceUtil.shareDiscount(priceMap, savedPrice);
	}

}
