package com.thebeastshop.pegasus.component.price;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.common.enums.AccessWayEnum;

/**
 * 计算商品价格的上下文。 仅用来展示时用此实现。
 *
 * @author Liang Wenjian
 */
public class PriceCalculateContextForPacks implements PriceCalculateContext {

	private MemberVO member;
	private AccessWayEnum accessWay;
	private Channel channel;
	private Map<ProductPack, BigDecimal> packAndOriginalPrice;
	private List<? extends ProductPack> packs;

	public PriceCalculateContextForPacks() {
		super();
	}

	public List<? extends ProductPack> getPacks() {
		return packs;
	}

	public void setPacks(List<? extends ProductPack> packs) {
		this.packs = packs;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	@Override
	public MemberVO getMember() {
		return member;
	}

	public void setMember(final MemberVO member) {
		this.member = member;
	}

	@Override
	public AccessWayEnum getAccessWay() {
		return accessWay;
	}

	public void setAccessWay(final AccessWayEnum accessWay) {
		this.accessWay = accessWay;
	}

	@Override
	public Map<ProductPack, BigDecimal> getPackAndOriginalPrice() {
		return packAndOriginalPrice;
	}

	public void setPackAndOriginalPrice(final Map<ProductPack, BigDecimal> packAndOriginalPrice) {
		this.packAndOriginalPrice = packAndOriginalPrice;
	}

	@Override
	public Channel getChannel() {
		return channel;
	}

	@Override
	public String toString() {
		return "{\"member\":\"" + member + "\",\"accessWay\":\"" + accessWay + "\",\"channel\":\"" + channel
				+ "\",\"packAndOriginalPrice\":\"" + packAndOriginalPrice + "\",\"packs\":\"" + packs + "\"}";
	}

}
