package com.thebeastshop.pegasus.component.file.service;

import java.io.File;
import java.io.InputStream;
import java.util.List;

import com.thebeastshop.pegasus.component.file.domain.FileInfo;

/**
 * 文件服务
 * 
 * @author Paul-xiong
 *
 */
public interface FileService {
	/**
	 * 根据本地文件路径上传文件
	 * 
	 * @param localFilePath
	 *            本地文件路径
	 * @param extraPath
	 *            额外的路径名
	 * @return 文件信息
	 * 
	 */
	public FileInfo uploadFile(String localFilePath, String extraPath);

	/**
	 * 根据文件对象上传文件
	 * 
	 * @param file
	 *            文件对象
	 * @param extraPath
	 *            额外的路径名
	 * @return 文件信息
	 */
	public FileInfo uploadFile(File file, String extraPath);

	/**
	 * 根据文件流上传文件
	 * 
	 * @param inputStream
	 *            输入流
	 * @param extraPath
	 *            额外的路径名
	 * @return 文件信息
	 * 
	 */
	public FileInfo uploadFile(InputStream inputStream, String extraPath);

	/**
	 * 获取文件列表
	 * 
	 * @param extraPath
	 *            额外的路径名
	 * @return
	 */
	public List<FileInfo> listFiles(String extraPath);

	/**
	 * 获取文件
	 * 
	 * @param fileUrl
	 *            文件url
	 * @return
	 */
	public FileInfo getFile(String fileUrl);

	/**
	 * 删除文件
	 * 
	 * @param fileUrl
	 *            文件url
	 * @return
	 */
	public void deleteFile(String fileUrl);

}
