package com.thebeastshop.pegasus.component.file;

import java.io.InputStream;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;

import com.thebeastshop.pegasus.component.file.domain.FileInfo;
import com.thebeastshop.pegasus.component.file.service.FileService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;

/**
 * 文件组件外观者
 * 
 * @author Paul-xiong
 *
 */
public class PegasusFileServiceFacade {

	private static PegasusFileServiceFacade instance;

	@Autowired
	private FileService fileService;

	public static PegasusFileServiceFacade getInstance() {
		if (instance != null) {
			return instance;
		}

		synchronized (PegasusFacadeLock.class) {
			if (instance == null) {
				instance = ComponentServiceLoader.getBean(PegasusFileServiceFacade.class);
			}
		}
		return instance;
	}

	/**
	 * 根据文件流上传文件
	 * 
	 * @param inputStream
	 *            输入流
	 * @param extraPath
	 *            额外的路径名
	 * @return 文件访问的URL
	 * 
	 */
	public FileInfo uploadFile(InputStream inputStream, String extraPath) {
		return this.fileService.uploadFile(inputStream, extraPath);
	}

	/**
	 * 删除文件
	 * 
	 * @param fileUrl
	 *            文件url
	 * @return
	 */
	public void deleteFile(String fileUrl) {
		this.fileService.deleteFile(fileUrl);
	}

	/**
	 * 获取文件列表
	 * 
	 * @param extraPath
	 *            额外的路径名
	 * @return
	 */
	public List<FileInfo> listFiles(String extraPath) {
		return this.fileService.listFiles(extraPath);
	}

}
