package com.thebeastshop.pegasus.component.delivery.constants;

import java.math.BigDecimal;

import org.apache.commons.lang.StringUtils;

import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.component.support.config.PropertyConfigurer;

/**
 * 邮费常量
 * 
 * @author Paul-xiong
 *
 */
public class PostageConstant {
	/**
	 * 普通商品免邮满足价格
	 */
	public static BigDecimal MEET_PRICE = BigDecimal.valueOf(99);
	/**
	 * 普通商品邮费
	 */
	public static BigDecimal NORMAL_PRICE = BigDecimal.valueOf(10);
	/**
	 * 海淘商品邮费
	 */
	public static BigDecimal OVER_SEA_POSTAGE = BigDecimal.valueOf(15);

	static {
		PropertyConfigurer configurer = ComponentServiceLoader.getBean(PropertyConfigurer.class);
		if (configurer != null) {
			if (configurer != null) {
				String meet_price = configurer.getProperty("postage.meet_price");
				if (StringUtils.isNotBlank(meet_price)) {
					MEET_PRICE = new BigDecimal(meet_price);
				}
				String normal_price = configurer.getProperty("postage.normal_price");
				if (StringUtils.isNotBlank(normal_price)) {
					NORMAL_PRICE = new BigDecimal(normal_price);
				}
				// String oversea_price =
				// configurer.getProperty("postage.oversea_price");
				// if (StringUtils.isNotBlank(oversea_price)) {
				// OVER_SEA_POSTAGE = new BigDecimal(oversea_price);
				// }

			}
		}
	}
}
