package com.thebeastshop.pegasus.component.customize.service.impl;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.customize.dao.CustomizeDao;
import com.thebeastshop.pegasus.component.customize.dao.mapper.SkuCustomizeMapper;
import com.thebeastshop.pegasus.component.customize.domain.SkuCustomize;
import com.thebeastshop.pegasus.component.customize.domain.SkuCustomizeExample;
import com.thebeastshop.pegasus.component.customize.service.SkuCustomizeService;

@Service
public class SkuCustomizeServiceImpl implements SkuCustomizeService {
	private final static Logger logger = LoggerFactory.getLogger(SkuCustomizeServiceImpl.class);
	@Autowired
	private CustomizeDao dao;

	@Override
	public int countByExample(SkuCustomizeExample example) {
		return dao.countByExample(example);
	}

	@Override
	public int deleteByExample(SkuCustomizeExample example) {
		return dao.deleteByExample(example);
	}

	@Override
	public int deleteByPrimaryKey(Long id) {
		return dao.deleteByPrimaryKey(id);
	}

	@Override
	public int insert(SkuCustomize record) {
		return dao.insert(record);
	}

	@Override
	public int insertSelective(SkuCustomize record) {
		return dao.insert(record);
	}

	@Override
	public List<SkuCustomize> selectByExample(SkuCustomizeExample example) {
		return dao.selectByExample(example);
	}

	@Override
	public SkuCustomize selectByPrimaryKey(Long id) {
		return dao.selectByPrimaryKey(id);
	}

	@Override
	public int updateByExampleSelective(SkuCustomize record, SkuCustomizeExample example) {
		return dao.updateByExampleSelective(record, example);
	}

	@Override
	public int updateByExample(SkuCustomize record, SkuCustomizeExample example) {
		return dao.updateByExample(record, example);
	}

	@Override
	public int updateByPrimaryKeySelective(SkuCustomize record) {
		return dao.updateByPrimaryKeySelective(record);
	}

	@Override
	public int updateByPrimaryKey(SkuCustomize record) {
		return dao.updateByPrimaryKey(record);
	}

	public CustomizeDao getDao() {
		return dao;
	}

	public void setDao(CustomizeDao dao) {
		this.dao = dao;
	}

	@Override
	public List<SkuCustomize> selectByPackId(Long packid) {

		List<SkuCustomize> customize = dao.selectByPackId(packid);
		logger.info("根据包裹id查询定制详情 ：", customize);
		return customize;

	}

}
