package com.thebeastshop.pegasus.component.compatible.service.impl;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.compatible.ResourceWithCode;
import com.thebeastshop.pegasus.component.compatible.service.IDCodeTransferService;
import com.thebeastshop.pegasus.merchandise.cond.PsProductCond;
import com.thebeastshop.pegasus.merchandise.cond.PsSkuCond;
import com.thebeastshop.pegasus.merchandise.service.McOpChannelService;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSkuService;
import com.thebeastshop.pegasus.merchandise.vo.OpChannelVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSkuVO;

/**
 * 一些资源的code值与插入数据库时的上下文有关（比如当时的时间），所以也没办法即时算出code，所以只能去表里拿字段值。
 *
 * @author Liang Wenjian
 */
@Service
public class IDCodeTransferServiceImpl implements IDCodeTransferService {

	@Autowired
	private McPsSkuService mcPsSkuService;
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private McOpChannelService mcOpChannelService;

	public IDCodeTransferServiceImpl() {
		super();
	}

	@Override
	public String getCode(final ResourceWithCode resourceWithCode, final long id) {
		// TODO：加缓存。
		if (resourceWithCode == ResourceWithCode.SKU) {
			PsSkuCond cond = new PsSkuCond();
			cond.setSkuId(id);
			List<PsSkuVO> skus = mcPsSkuService.findByCond(cond);
			return skus.get(0).getSkuCode();
		} else if (resourceWithCode == ResourceWithCode.PRODUCT) {
			PsProductVO prod = mcPsProductService.findByProdId(id);
			return prod.getCode();
		} else if (resourceWithCode == ResourceWithCode.CHANNEL) {
			OpChannelVO opChannel = mcOpChannelService.findById(id);
			return opChannel.getCode();
		} else if (resourceWithCode == ResourceWithCode.WAREHOUSE) {

		}
		return null;
	}

	@Override
	public List<String> getCodes(ResourceWithCode resourceWithCode, List<Long> ids) {
		if (CollectionUtils.isNotEmpty(ids)) {
			List<String> rt = Lists.newArrayListWithExpectedSize(ids.size());
			if (resourceWithCode == ResourceWithCode.PRODUCT) {
				PsProductCond cond = new PsProductCond();
				List<String> idsStr = Lists.newArrayListWithExpectedSize(ids.size());
				for (Long id : ids) {
					idsStr.add(id.toString());
				}
				cond.setIds(idsStr);
				List<PsProductVO> products = mcPsProductService.findByCond(cond);
				for (PsProductVO psProductVO : products) {
					rt.add(psProductVO.getCode());
				}
			}
			return rt;
		}
		return null;
	}

	@Override
	public Long getId(ResourceWithCode resourceWithCode, String code) {
		// TODO：加缓存。
		if (resourceWithCode == ResourceWithCode.PRODUCT) {
			List<PsProductVO> products = mcPsProductService.findByProdCode(code);
			if (CollectionUtils.isNotEmpty(products)) {
				return Long.valueOf(products.get(0).getId());
			}
		}
		return null;
	}

	@Override
	public List<Long> getIds(ResourceWithCode resourceWithCode, List<String> codes) {
		if (CollectionUtils.isNotEmpty(codes)) {
			List<Long> rt = Lists.newArrayListWithExpectedSize(codes.size());
			if (resourceWithCode == ResourceWithCode.PRODUCT) {
				PsProductCond cond = new PsProductCond();
				cond.setCodes(codes);
				List<PsProductVO> products = mcPsProductService.findByCond(cond);
				for (PsProductVO psProductVO : products) {
					rt.add(Long.valueOf(psProductVO.getId()));
				}
			}
			return rt;
		}
		return null;
	}

}
