package com.thebeastshop.pegasus.component.compatible.old;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;

public class ItemDo implements Serializable {
	private static final long serialVersionUID = -3435477917325544023L;

	private Long itemId; // OE商品ID

	private String skuId;
	private String productCode;

	private String name; // 商品英文名

	private String title; // 商品中文标题

	private Long brandId; // OE品牌ID

	private String brandName; // OE品牌名称
	private Long price; // 原价（分）
	private Long maxPrice; // product对应的可售商品的最高价,展示详情页的价格区间

	private Long vipPrice; // vip价格（分）

	private Long vvipPrice; // vvip价格（分）

	private int vipEnable = 1; // 该产品是否可以VIP打折,0表示可以打折,1表示不可以打折

	private int saleOk = 0; // 是否下架 0表示正常销售 1表示下架 来自OE系统

	private int status = 0; // 0是正常状态

	private long quantity = 0;

	private String autoFetchAddress;

	private int allowAutoFetch;

	private int allowQrCode;

	private String smallImgUrl; // 列表图（长方形图）

	private String bigImgUrl; // 详情图(图文详情页的图)

	private String cartImgUrl; // 购物车和推荐商品（正方形小图）

	private String weixinImgUrl;

	private String relateItemIds; // itemId,skuId;itemId,skuId;

	private Date startDate; // 销售起始日期

	private Date endDate; // 销售终止日期

	private Date gmtCreate;

	private Date gmtModify;

	private String deliveryDates; // 可配送日期
									// 格式如：2014-10-10,2014-10-11,2014-10-12,2014-10-13

	private String pickScope; // FEDEX24 24小时联邦、FEDEX48 48小时联邦、FEDEX72
								// 72小时联邦、SELF 自带物流、OTHERS 其它物流

	private int remarkEnable = 1; // 销售时是否可以备注，0表示可以，1表示不可以

	private Long userVipPrice = 0l;
	private Long userVipMaxPrice = 0l;// vip对应的商品最大折扣价。对应vip的最高折扣区间
	private Long userVipMinPrice = 0l;// vip对应的商品最小折扣价。对应vip的最高折扣区间
	private Integer invisibleOnWeb = 1; // 0表示不可见 1表示可见

	private String substituteType; // 关联产品属性名称，有子商品时才有意义

	private String subProds; // id:skuid:substituteName&id:skuid:substituteName

	private String substituteName; // 子商品的具体“型号”值

	private Long parentId; // 父商品ID

	private String shopIds; // 可销售渠道ID，多个渠道以分号分隔 老的官网是2， 新的官网是18

	// private int isFlower; //0表示非花，1表示花

	private ItemDo parentItem;

	private String keywords;

	private String description;

	private String deliveryCityIds; // 配送城市。 城市ID对应 标准化省市区接口里的城市ID
	private String deliveryNotCityIds;
	private Long discountPrice = 0l;// 折扣价 单位为分
	private Long originalDiscountPrice = 0l;// 折扣价 单位为分
	private Long discountMaxPrice = 0l;// 折扣价的最大区间,母商品展示展示价格区间使用
	private Long discountMinPrice = 0l;// 折扣价的最小区间,母商品展示展示价格区间使用
	private int pointChangeEnable;// 是否积分兑换

	private Long pointPrice;// 积分兑换价格,
	private Long pointValue;
	private String wapDetailImages;// 手机端详情页面支持多张图 多张图使用逗号分隔

	/**
	 * 跨境购标注 0普通１跨境购
	 */
	private Integer crossBorderFlag = 0;
	/**
	 * 列表标签
	 */
	private String listIcon;
	/**
	 * 详情标签
	 */
	private String detailIcon;
	/**
	 * 图标显示内容
	 */
	private String tagList;

	/**
	 * 产地
	 */
	private String placeOfOrigin;

	/**
	 * 品类
	 */
	private String frontCategories;
	private String categoryCods;
	/**
	 * 一句话描述
	 */
	private String shortDescription;
	private String campaignListJson; // 活动类型json string

	/**
	 * 折扣可使用级别
	 */
	private String discountLevel;
	/**
	 * 折扣价开始时间
	 */
	private Date discountStartTime;
	/**
	 * 折扣价结束时间
	 */
	private Date discountEndTime;

	private Integer isJit;

	public String getCampaignListJson() {
		return campaignListJson;
	}

	public void setCampaignListJson(String campaignListJson) {
		this.campaignListJson = campaignListJson;
	}

	public int getAllowAutoFetch() {
		return allowAutoFetch;
	}

	public int getAllowQrCode() {
		return allowQrCode;
	}

	public String getAutoFetchAddress() {
		return autoFetchAddress;
	}

	public String getBigImgUrl() {
		return bigImgUrl;
	}

	public Long getBrandId() {
		return brandId;
	}

	public String getBrandName() {
		return brandName;
	}

	public boolean getCanSale() {
		if (saleOk == 0)
			return true;

		return false;
	}

	public String getCartImgUrl() {
		return cartImgUrl;
	}

	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public String getDeliveryCityIds() {
		return deliveryCityIds;
	}

	public String getDeliveryDates() {
		return deliveryDates;
	}

	public String getDescription() {
		return description;
	}

	public Long getDiscountMaxPrice() {
		return discountMaxPrice;
	}

	public double getDiscountMaxPriceYuan() {
		if (discountMaxPrice != null && discountMaxPrice > 0) {
			BigDecimal fenbd = new BigDecimal(discountMaxPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		}
		return 0;
	}

	public Long getDiscountMinPrice() {
		return discountMinPrice;
	}

	public double getDiscountMinPriceYuan() {
		if (discountMinPrice != null && discountMinPrice > 0) {
			BigDecimal fenbd = new BigDecimal(discountMinPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		}
		return 0;
	}

	public Long getDiscountPrice() {
		return discountPrice;
	}

	public double getDiscountPriceYuan() {
		if (discountPrice > 0) {
			BigDecimal fenbd = new BigDecimal(discountPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public double getOriginalDiscountPriceYuan() {
		if (originalDiscountPrice > 0) {
			BigDecimal fenbd = new BigDecimal(originalDiscountPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public Long getOriginalDiscountPrice() {
		return originalDiscountPrice;
	}

	public void setOriginalDiscountPrice(Long originalDiscountPrice) {
		this.originalDiscountPrice = originalDiscountPrice;
	}

	public Date getEndDate() {
		return endDate;
	}

	public Date getGmtCreate() {
		return gmtCreate;
	}

	public Date getGmtModify() {
		return gmtModify;
	}

	public Integer getInvisibleOnWeb() {
		return invisibleOnWeb;
	}

	public Long getItemId() {
		return itemId;
	}

	public String getKeywords() {
		if ("".equals(keywords) || null == keywords || (keywords != null && keywords.equals(title))) {
			return title;
		} else {
			return this.keywords;
		}
	}

	public Long getMaxPrice() {
		return maxPrice;
	}

	public double getMaxPriceYuan() {
		if (maxPrice != null) {
			BigDecimal fenbd = new BigDecimal(maxPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		}
		return getPriceYuan();
	}

	public String getName() {
		return name;
	}

	public Long getParentId() {
		return parentId;
	}

	public ItemDo getParentItem() {
		return parentItem;
	}

	public String getPickScope() {
		return pickScope;
	}

	public int getPointChangeEnable() {
		return pointChangeEnable;
	}

	public Long getPointPrice() {
		return pointPrice;
	}

	// 20150626 ztq
	public double getPointPriceYuan() {
		if (pointPrice != null) {
			BigDecimal fenbd = new BigDecimal(pointPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public Long getPointValue() {
		return pointValue;
	}

	public Long getPrice() {
		return price;
	}

	public double getPriceYuan() {
		if (price != null) {
			BigDecimal fenbd = new BigDecimal(price);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public long getQuantity() {
		return quantity;
	}

	public String getRelateItemIds() {
		return relateItemIds;
	}

	public int getRemarkEnable() {
		return remarkEnable;
	}

	public int getSaleOk() {
		return saleOk;
	}

	public String getShopIds() {
		return shopIds;
	}

	public String getSkuId() {
		return skuId;
	}

	public String getSmallImgUrl() {
		return smallImgUrl;
	}

	public Date getStartDate() {
		return startDate;
	}

	public int getStatus() {
		return status;
	}

	public String getSubProds() {
		return subProds;
	}

	public String getSubstituteName() {
		return substituteName;
	}

	public String getSubstituteType() {
		return substituteType;
	}

	public String getTitle() {
		return title;
	}

	public Long getUserPrice(String custLevel) {
		if ("vip".equals(custLevel) && vipEnable == 0) {
			if (vipPrice != null && vipPrice > 0) {
				return vipPrice;
			}
		} else if (("vvip".equals(custLevel) || "3vip".equals(custLevel)) && vipEnable == 0) {
			if (vvipPrice != null && vvipPrice > 0) {
				return vvipPrice;
			} else {
				if (vipPrice != null && vipPrice > 0) {
					return vipPrice;
				}
			}
		}

		return price;
	}

	public String getUserPriceType(String custLevel) {
		if ("vip".equals(custLevel) && vipEnable == 0) {
			if (vipPrice != null && vipPrice > 0 && price > vipPrice) {
				return "vip";
			}
		} else if (("vvip".equals(custLevel) || "3vip".equals(custLevel)) && vipEnable == 0) {
			if (vvipPrice != null && vvipPrice > 0 && price > vvipPrice) {
				return "vvip";
			} else {
				if (vipPrice != null && vipPrice > 0 && price > vipPrice) {
					return "vip";
				}
			}
		}

		return "normal";
	}

	public double getUserPriceYuan(String custLevel) {
		Long userPrice = price;
		if ("vip".equals(custLevel) && vipEnable == 0) {
			if (vipPrice != null && vipPrice > 0) {
				userPrice = vipPrice;
			}
		} else if (("vvip".equals(custLevel) || "3vip".equals(custLevel)) && vipEnable == 0) {
			if (vvipPrice != null && vvipPrice > 0) {
				userPrice = vvipPrice;
			} else {
				if (vipPrice != null && vipPrice > 0) {
					userPrice = vipPrice;
				}
			}
		}

		if (userPrice != null) {
			BigDecimal fenbd = new BigDecimal(userPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public Long getUserVipMaxPrice() {
		return userVipMaxPrice;
	}

	public double getUserVipMaxPriceYuan() {
		if (userVipMaxPrice != null && userVipMaxPrice > 0) {
			BigDecimal fenbd = new BigDecimal(userVipMaxPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		}
		return 0;
	}

	public Long getUserVipMinPrice() {
		return userVipMinPrice;
	}

	public double getUserVipMinPriceYuan() {
		if (userVipMinPrice != null && userVipMinPrice > 0) {
			BigDecimal fenbd = new BigDecimal(userVipMinPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		}
		return 0;
	}

	public Long getUserVipPrice() {
		return userVipPrice;
	}

	public double getUserVipPriceYuan() {
		if (userVipPrice != null && userVipPrice > 0) {
			BigDecimal fenbd = new BigDecimal(userVipPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public int getVipEnable() {
		return vipEnable;
	}

	public Long getVipPrice() {
		return vipPrice;
	}

	public double getVipPriceYuan() {
		if (vipPrice != null) {
			BigDecimal fenbd = new BigDecimal(vipPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public Long getVvipPrice() {
		return vvipPrice;
	}

	public double getVvipPriceYuan() {
		if (vvipPrice != null) {
			BigDecimal fenbd = new BigDecimal(vvipPrice);
			double yuan = fenbd.divide(new BigDecimal(100 + ""), 2, BigDecimal.ROUND_HALF_UP).doubleValue();
			return yuan;
		} else {
			return 0d;
		}
	}

	public String getWapDetailImages() {
		return wapDetailImages;
	}

	public List<String> getWapDetailImagesList() {
		List<String> wapDetailImageList = new ArrayList<String>();
		if (StringUtils.isNotBlank(wapDetailImages)) {
			wapDetailImageList.addAll(Arrays.asList(wapDetailImages.split(",")));// 手机端详情页使用多张图
		}
		return wapDetailImageList;
	}

	public String getWeixinImgUrl() {
		return weixinImgUrl;
	}

	public boolean isVisibleOnWeb() {
		return (invisibleOnWeb == 1);
	}

	public void setAllowAutoFetch(int allowAutoFetch) {
		this.allowAutoFetch = allowAutoFetch;
	}

	public void setAllowQrCode(int allowQrCode) {
		this.allowQrCode = allowQrCode;
	}

	public void setAutoFetchAddress(String autoFetchAddress) {
		this.autoFetchAddress = autoFetchAddress;
	}

	public void setBigImgUrl(String bigImgUrl) {
		this.bigImgUrl = bigImgUrl;
	}

	public void setBrandId(Long brandId) {
		this.brandId = brandId;
	}

	public void setBrandName(String brandName) {
		this.brandName = brandName;
	}

	public void setCartImgUrl(String cartImgUrl) {
		this.cartImgUrl = cartImgUrl;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	public void setDeliveryCityIds(String deliveryCityIds) {
		this.deliveryCityIds = deliveryCityIds;
	}

	public void setDeliveryDates(String deliveryDates) {
		this.deliveryDates = deliveryDates;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setDiscountMaxprice(Long discountMaxPrice) {
		this.discountMaxPrice = discountMaxPrice;
	}

	public void setDiscountMinPrice(Long discountMinPrice) {
		this.discountMinPrice = discountMinPrice;
	}

	public void setDiscountPrice(Long discountPrice) {
		this.discountPrice = discountPrice;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public void setGmtCreate(Date gmtCreate) {
		this.gmtCreate = gmtCreate;
	}

	public void setGmtModify(Date gmtModify) {
		this.gmtModify = gmtModify;
	}

	public void setInvisibleOnWeb(Integer invisibleOnWeb) {
		this.invisibleOnWeb = invisibleOnWeb;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public void setKeywords(String keywords) {
		this.keywords = keywords;
	}

	public void setMaxPrice(Long maxPrice) {
		this.maxPrice = maxPrice;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public void setParentItem(ItemDo parentItem) {
		this.parentItem = parentItem;
	}

	public void setPickScope(String pickScope) {
		this.pickScope = pickScope;
	}

	public void setPointChangeEnable(int pointChangeEnable) {
		this.pointChangeEnable = pointChangeEnable;
	}

	public void setPointPrice(Long pointPrice) {
		this.pointPrice = pointPrice;
	}

	public void setPointValue(Long pointValue) {
		this.pointValue = pointValue;
	}

	public void setPrice(Long price) {
		this.price = price;
	}

	public void setQuantity(long quantity) {
		this.quantity = quantity;
	}

	public void setRelateItemIds(String relateItemIds) {
		this.relateItemIds = relateItemIds;
	}

	public void setRemarkEnable(int remarkEnable) {
		this.remarkEnable = remarkEnable;
	}

	public void setSaleOk(int saleOk) {
		this.saleOk = saleOk;
	}

	public void setShopIds(String shopIds) {
		this.shopIds = shopIds;
	}

	public void setSkuId(String skuId) {
		this.skuId = skuId;
	}

	public void setSmallImgUrl(String smallImgUrl) {
		this.smallImgUrl = smallImgUrl;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public void setSubProds(String subProds) {
		this.subProds = subProds;
	}

	public void setSubstituteName(String substituteName) {
		this.substituteName = substituteName;
	}

	public void setSubstituteType(String substituteType) {
		this.substituteType = substituteType;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	public void setUserVipMaxPrice(Long userVipMaxPrice) {
		this.userVipMaxPrice = userVipMaxPrice;
	}

	public void setUserVipMinPrice(Long userVipMinPrice) {
		this.userVipMinPrice = userVipMinPrice;
	}

	// 同时设置折扣价
	public void setUserVipPrice(String custLevel, String useGiftCard) {

		if ("vip".equals(custLevel) && vipEnable == 0) {
			if (vipPrice != null && vipPrice > 0 && price > vipPrice) {
				userVipPrice = vipPrice;
			}

			// 增加折扣价设置
			if (discountPrice != null && discountPrice > 0) {
				if (!"1".equals(useGiftCard)) {
					discountPrice = BigDecimal.valueOf(discountPrice).multiply(BigDecimal.valueOf(0.95)).longValue();
				}

			}
		} else if (("vvip".equals(custLevel) || "3vip".equals(custLevel)) && vipEnable == 0) {
			if (vvipPrice != null && vvipPrice > 0 && price > vvipPrice) {
				userVipPrice = vvipPrice;
			} else {
				if (vipPrice != null && vipPrice > 0 && price > vipPrice) {
					userVipPrice = vipPrice;
				}
			}
			// 增加折扣价设置
			if (discountPrice != null && discountPrice > 0) {
				if (!"1".equals(useGiftCard)) {
					discountPrice = BigDecimal.valueOf(discountPrice).multiply(BigDecimal.valueOf(0.90)).longValue();
				}

			}
		}
	}

	public void setVipEnable(int vipEnable) {
		this.vipEnable = vipEnable;
	}

	public void setVipPrice(Long vipPrice) {
		this.vipPrice = vipPrice;
	}

	public void setVvipPrice(Long vvipPrice) {
		this.vvipPrice = vvipPrice;
	}

	public void setWapDetailImages(String wapDetailImages) {
		this.wapDetailImages = wapDetailImages;
	}

	public void setWeixinImgUrl(String weixinImgUrl) {
		this.weixinImgUrl = weixinImgUrl;
	}

	public Map<String, Object> toTitleMap() {
		Map<String, Object> map = new LinkedHashMap<String, Object>();
		map.put("SKU", skuId == null ? "" : skuId);
		map.put("标题", title == null ? "" : title);
		return map;
	}

	public String getDeliveryNotCityIds() {
		return deliveryNotCityIds;
	}

	public void setDeliveryNotCityIds(String deliveryNotCityIds) {
		this.deliveryNotCityIds = deliveryNotCityIds;
	}

	public String getListIcon() {
		return listIcon;
	}

	public void setListIcon(String listIcon) {
		this.listIcon = listIcon;
	}

	public String getDetailIcon() {
		return detailIcon;
	}

	public void setDetailIcon(String detailIcon) {
		this.detailIcon = detailIcon;
	}

	public String getTagList() {
		return tagList;
	}

	public void setTagList(String tagList) {
		this.tagList = tagList;
	}

	public String getPlaceOfOrigin() {
		return placeOfOrigin;
	}

	public void setPlaceOfOrigin(String placeOfOrigin) {
		this.placeOfOrigin = placeOfOrigin;
	}

	public String getFrontCategories() {
		return frontCategories;
	}

	public void setFrontCategories(String frontCategories) {
		this.frontCategories = frontCategories;
	}

	public String getCategoryCods() {
		return categoryCods;
	}

	public void setCategoryCods(String categoryCods) {
		this.categoryCods = categoryCods;
	}

	public String getShortDescription() {
		return shortDescription;
	}

	public void setShortDescription(String shortDescription) {
		this.shortDescription = shortDescription;
	}

	public String getDiscountLevel() {
		return discountLevel;
	}

	public void setDiscountLevel(String discountLevel) {
		this.discountLevel = discountLevel;
	}

	public Date getDiscountStartTime() {
		return discountStartTime;
	}

	public void setDiscountStartTime(Date discountStartTime) {
		this.discountStartTime = discountStartTime;
	}

	public Date getDiscountEndTime() {
		return discountEndTime;
	}

	public void setDiscountEndTime(Date discountEndTime) {
		this.discountEndTime = discountEndTime;
	}

	public Integer getIsJit() {
		return isJit;
	}

	public void setIsJit(Integer isJit) {
		this.isJit = isJit;
	}

	public String getProductCode() {
		return productCode;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

}
