package com.thebeastshop.pegasus.component.channel;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.pegasus.component.channel.support.DefaultChannelImpl;
import com.thebeastshop.support.mark.HasCreateTime;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.mark.Type;

@JsonDeserialize(as = DefaultChannelImpl.class)
public interface Channel extends HasLongIdGetter, HasName, HasCreateTime {

	/**
	 * 渠道编号
	 * 
	 * @return
	 */
	String getCode();

	/**
	 * 渠道类型
	 * 
	 * @return
	 */
	Type getType();

	/**
	 * 仓库编号
	 * 
	 * @return
	 */
	String getWarehouseCode();
	
	/**
	 * 线上线下类型
	 */
	Integer getChannelType();

}
