package com.thebeastshop.pegasus.component.category.support;

import java.util.Date;

import com.thebeastshop.pegasus.component.category.Category;
import com.thebeastshop.pegasus.component.category.model.CategoryEntity;

/**
 * @author Liang Wenjian
 */
public class OldModelAdaptorCategory extends CategoryTemplate {

	private static final Integer IN_USE = 1;
	private static final Integer NOT_IN_USE = 0;// 是0吧？？？

	public static boolean inUseToValid(final CategoryEntity oldModel) {
		return IN_USE.equals(oldModel.getInUse());
	}

	public static int validToInUse(final Category category) {
		return category.isValid() ? IN_USE : NOT_IN_USE;
	}

	private CategoryEntity oldModel;

	public OldModelAdaptorCategory(final CategoryEntity entity) {
		super();
		this.oldModel = entity;
	}

	@Override
	public String getNote() {
		return "";
	}

	@Override
	public Date getCreateTime() {
		return null;
	}

	@Override
	public Long getParentId() {
		return oldModel.getParentId();
	}

	@Override
	public Long getId() {
		return oldModel.getId();
	}

	@Override
	public String getName() {
		return oldModel.getName();
	}

	@Override
	public boolean isValid() {
		return inUseToValid(oldModel);
	}
}
