package com.thebeastshop.pegasus.component.category.service.impl;

import java.util.Collection;
import java.util.List;

import com.thebeastshop.pegasus.component.category.CampaignCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.category.Category;
import com.thebeastshop.pegasus.component.category.dao.CategoryDao;
import com.thebeastshop.pegasus.component.category.service.CategoryService;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.util.IdUtil;

/**
 * @author Liang Wenjian
 */
@Service
public class CategoryServiceImpl implements CategoryService {

	@Autowired
	private CategoryDao categoryDao;

	public CategoryServiceImpl() {
		super();
	}

	@Override
	public Collection<Category> list() {
		return this.categoryDao.list();
	}

	@Override
	public Category getById(final Long id) {
		return this.categoryDao.getById(id);
	}

	@Override
	public void modify(final Category one) {
		this.categoryDao.modify(one);
	}

	@Override
	public void del(final Category category) {
		this.categoryDao.del(category);
	}

	@Override
	public Category create(final Category one) {
		return this.categoryDao.create(one);
	}

	@Override
	public Category checkOne(Long id) {
		final Category one = getById(id);
		if (one == null) {
			throw new NoSuchResourceException("分类", id);
		}
		return one;
	}

	@Override
	public void del(Long id) {
		final Category one = getById(id);
		if (one != null) {
			del(one);
		}
	}

	@Override
	public void del(Collection<Category> categories) {
		for (Category category : categories) {
			del(category);
		}
	}

	@Override
	public Collection<Category> directChildren(Category one) {
		return categoryDao.directChildren(one);
	}

	@Override
	public Collection<Category> subordinates(Category one) {
		return categoryDao.subordinates(one);
	}

	@Override
	public boolean isRoot(Category one) {
		return one.getParentId() == null;
	}

	@Override
	public Category getParent(Category one) {
		final Logger logger = LoggerFactory.getLogger(getClass());
		logger.debug(getClass().getSimpleName() + ".getParent(Category) start:" + one);
		final Category rt = isRoot(one) ? null : getById(one.getParentId());
		logger.debug(getClass().getSimpleName() + ".getParent(Category) end:" + rt);
		return rt;
	}

	@Override
	public List<Category> ancestors(Category one) {
		final Logger logger = LoggerFactory.getLogger(getClass());
		logger.debug(getClass().getSimpleName() + ".ancestors(Category) start:" + one);
		final List<Category> rt = Lists.newArrayList();
		Category o = one;
		while (o != null) {
			final Category parent = getParent(o);
			if (parent != null) {
				rt.add(parent);
				o = parent;
			}
		}
		logger.debug(getClass().getSimpleName() + ".ancestors(Category) end:" + rt);
		return rt;
	}

	@Override
	public boolean isAncestor(Category bigger, Category smaller) {
		final Logger logger = LoggerFactory.getLogger(getClass());
		logger.debug(getClass().getSimpleName() + ".isAncestor start:" + bigger + ", " + smaller);
		final List<Category> ancestors = ancestors(smaller);
		final boolean b = IdUtil.toIds(ancestors).contains(bigger.getId());
		logger.debug(getClass().getSimpleName() + ".isAncestor end:" + b);
		return b;
	}

	@Override
	public List<CampaignCategory> getCategoryByCampaignId(Long campaignId, Boolean temp) {
		return categoryDao.getCategoryByCampaignId(campaignId, temp);
	}

	@Override
	public List<CampaignCategory> getAllCategories() {
		return categoryDao.getAllCategories();
	}

	@Override
	public List<Long> getTreeNode(List<Long> categories) {
		return categoryDao.getTreeNode(categories);
	}

	@Override
	public String getCodeById(Long bindingId) {
		return categoryDao.getCodeById(bindingId);
	}

	@Override
	public List<Long> getCategoryIdsByCampaignId(Long campaignId, Boolean temp) {
		return categoryDao.getCategoryIdsByCampaignId(campaignId, temp);
	}
}
