package com.thebeastshop.pegasus.component.category.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.category.CategoryFront;
import com.thebeastshop.pegasus.component.category.dao.CategoryDao;
import com.thebeastshop.pegasus.component.category.dao.CategoryFrontDao;
import com.thebeastshop.pegasus.component.category.service.CategoryFrontService;

@Service
public class CategoryFrontServieImpl implements CategoryFrontService {
	private final static Logger logger = LoggerFactory.getLogger(CategoryFrontServieImpl.class);
	@Autowired
	private CategoryFrontDao categoryFrontDao;
	@Autowired
	private CategoryDao categoryDao;

	@Override
	public List<CategoryFront> getFirstLevelCategories() {
		List<CategoryFront> CategoryFrontList = categoryFrontDao.getFirstCategory();
		return CategoryFrontList;
	}

	@Override
	public List<Long> getCategoryIdsByCodes(List<String> categoryCode) {
		List<Long> categoryIds = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(categoryCode)) {
			// 通过code 查询所有的 ids
			List<String> categorycodes = new ArrayList<>();
			categorycodes.addAll(categoryCode);
			int i = 0;
			do {
				List<CategoryFront> categoryFronts = categoryFrontDao.getLeftCategorIdsByCodes(categorycodes);
				List<String> c = new ArrayList<>();
				for (CategoryFront categoryFront : categoryFronts) {
					categoryIds.add(categoryFront.getId());
					c.add(categoryFront.getCode());
				}
				categorycodes.removeAll(c);
				// 通过code 查询子类目
				if (CollectionUtils.isNotEmpty(categorycodes)) {
					List<String> bcsd = categoryFrontDao.getCategoryCodeBycode(categorycodes);
					if (CollectionUtils.isNotEmpty(bcsd)) {
						categorycodes.clear();
						categorycodes.addAll(bcsd);
					} else {
						categorycodes.clear();
						logger.info("===分类查询异常");
					}
				}
				logger.info("===查询条件  categorycodes={} ", categorycodes);
				// 重新设置 子类目
				i++;
				if (i == 5) {
					break;
				}
			} while (!categorycodes.isEmpty());
		}
		return categoryIds;
	}

	@Override
	public List<CategoryFront> getCategoriesByIds(List<Long> categoryIds) {
		List<CategoryFront> CategoryFrontList = categoryFrontDao.getCategoryFrontisById(categoryIds);
		return CategoryFrontList;
	}

	@Override
	public List<CategoryFront> getCategoriesByParentId(Integer parentId) {
		List<CategoryFront> CategoryFrontList = categoryFrontDao.getCategoriesByParentId(parentId);
		return CategoryFrontList;
	}

	@Override
	public List<Long> getAllCategories() {
		List<Long> CategoryFrontList = new ArrayList<Long>();
		CategoryFrontList = categoryFrontDao.getAllCategories();
		return CategoryFrontList;
	}
}
