package com.thebeastshop.pegasus.component.category.service;

import java.util.Collection;
import java.util.List;

import com.thebeastshop.pegasus.component.category.CampaignCategory;
import com.thebeastshop.pegasus.component.category.Category;
import com.thebeastshop.support.exception.NoSuchResourceException;

/**
 * @author Liang Wenjian
 */
public interface CategoryService {

	/**
	 * 获取分类列表。
	 *
	 * @return
	 */
	Collection<Category> list();

	/**
	 * 带检查地获取一个分类。
	 *
	 * @param id
	 * @return
	 * @throws NoSuchResourceException
	 *             若此id指定的分类不存在
	 */
	Category checkOne(final Long id);

	/**
	 * 获取一个分类。
	 *
	 * @param id
	 * @return 若无，则返回null
	 */
	Category getById(final Long id);

	/**
	 * 修改
	 *
	 * @param one
	 */
	void modify(Category one);

	/**
	 * 删除
	 *
	 * @param id
	 */
	void del(final Long id);

	void del(Category category) throws UnsupportedOperationException;

	void del(final Collection<Category> categories);

	/**
	 * 创建一个分类。
	 *
	 * @param one
	 *            分类
	 * @return 创建后的分类。
	 */
	Category create(final Category one);

	// /**
	// * 重命名一个分类。
	// *
	// * @param category 分类
	// */
	// default void rename(final Category category) {
	// final Logger logger = LoggerFactory.getLogger(getClass());
	// logger.debug(getClass().getSimpleName() + ".rename(Category) start:" +
	// category);
	// final Category one = getById(category.getId());
	// modify(new CategoryForRename(one, category.getName()));
	// logger.debug(getClass().getSimpleName() + ".rename(Category) end.");
	// }

	// ---------------------------父子关系

	/**
	 * 获取某分类的直接子分类。
	 *
	 * @return 子分类列表。
	 */
	Collection<Category> directChildren(final Category one);

	/**
	 * 获取所有后代
	 *
	 * @param one
	 *            分类
	 * @return 所有后代
	 */
	Collection<Category> subordinates(final Category one);

	// /**
	// * 将某分类及其子孙分类构建成树形结构。
	// *
	// * @param category 分类
	// * @return 分类（树形）
	// */
	// default CategoryWithChildren tree(final Category category) {
	// final Logger logger = LoggerFactory.getLogger(getClass());
	// logger.debug(getClass().getSimpleName() + ".tree(ids) start:" +
	// category);
	// final CategoryWithChildren rt = new CategoryWithChildren(category,//
	// directChildren(category).stream()//
	// .map(this::tree)//
	// .collect(Collectors.toList()));
	// logger.debug(getClass().getSimpleName() + ".tree(ids) end:" + rt);
	// return rt;
	// }

	/**
	 * 判断一个分类是否根级分类。
	 *
	 * @param one
	 *            分类
	 * @return 是否根分类。
	 */
	boolean isRoot(final Category one);

	/**
	 * 获取某分类的父级分类。若此分类是根级分类，则返回null。
	 *
	 * @param one
	 *            分类
	 * @return 父分类
	 */
	Category getParent(final Category one);

	/**
	 * 获取本分类的所有上级（不包括自己）。层次上离此分类越近者，在返回的列表中越靠前（即第一个元素将是直接父分类）。
	 *
	 * @param one
	 *            分类
	 * @return 所有上级分类。
	 */
	List<Category> ancestors(final Category one);

	/**
	 * 判断前者是否后者的祖先。
	 *
	 * @param bigger
	 *            可能是祖先的分类。
	 * @param smaller
	 *            可能是后代的分类。
	 * @return 有无继承关系。
	 */
	boolean isAncestor(final Category bigger, final Category smaller);

	// default void changeParent(final Category category, final Category
	// newParent) {
	// final Integer newParentId = newParent.getId();
	// if (Objects.equals(category.getParentId(), newParentId)) {
	// return;
	// }
	// if (isAncestor(category, newParent)) {
	// throw new WrongStateException("不能将分类移至下属分类之下", "Category is ancestor of
	// newParent", true);
	// }
	// modify(new CategoryForChangeParent(category, newParentId));
	// }

	/**
	 * 根据活动编号获取该活动涉及的所有分类目录
	 *
	 * @param campaignId 活动编号
	 *
	 * @return
	 */
	List<CampaignCategory> getCategoryByCampaignId(Long campaignId, Boolean temp);

	/**
	 * 获取所有的分类
	 *
	 * @return
	 */
	List<CampaignCategory> getAllCategories();

	/**
	 * 获取指定类目的所有最低级类目
	 *
	 * @param categories
	 *
	 * @return
	 */
	List<Long> getTreeNode(List<Long> categories);

	/**
	 * 根据id获取类目编码
	 *
	 * @param bindingId
	 *
	 * @return
	 */
	String getCodeById(Long bindingId);

	/**
	 * 获取指定活动中勾选的类目编号集合
	 * @param campaignId    活动编号
	 * @param temp 是否临时记录
	 * @return
	 */
	List<Long> getCategoryIdsByCampaignId(Long campaignId, Boolean temp);
}
