package com.thebeastshop.pegasus.component.category.service;

import java.util.List;

import com.thebeastshop.pegasus.component.category.CategoryFront;

public interface CategoryFrontService {

	/**
	 * 获取前端一级类目下的子类目
	 * 
	 * @author jim.huang
	 * @date 2016年8月5日
	 * @return
	 */
	public List<CategoryFront> getCategoriesByParentId(Integer parentId);

	/**
	 * 获取所有一级类目
	 * 
	 * @author jim.huang
	 * @date 2016年8月5日
	 * @return
	 */
	public List<CategoryFront> getFirstLevelCategories();

	/**
	 * 通过分类id 得到 所有叶子结点的前台分类
	 * 
	 * @author lijing
	 * @time 2016-09-06
	 * @param categoryCode
	 *            前端分类code
	 * @return
	 */
	public List<Long> getCategoryIdsByCodes(List<String> categoryCode);

	/**
	 * 通过id 查新对象
	 * 
	 * @param categoryIds
	 * @return
	 */
	public List<CategoryFront> getCategoriesByIds(List<Long> categoryIds);

	/**
	 * 获取所有子类目
	 * 
	 * @author WangYawei
	 * @date 2017-5-12
	 * @return
	 */
	public List<Long> getAllCategories();

}
