package com.thebeastshop.pegasus.component.category.dao.impl;

import java.util.ArrayList;
import java.util.List;

import com.thebeastshop.support.coll.CollectionUtil;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.category.CategoryFront;
import com.thebeastshop.pegasus.component.category.dao.CategoryFrontDao;
import com.thebeastshop.pegasus.component.category.dao.mapper.CategoryFrontEntityMapper;
import com.thebeastshop.pegasus.component.category.model.CategoryFrontEntity;
import com.thebeastshop.pegasus.component.category.model.CategoryFrontEntityExample;
import com.thebeastshop.pegasus.component.category.support.OldModelAdaptorCategoryFront;

@Repository
public class CategoryFrontDaoImpl implements CategoryFrontDao {

	@Autowired
	private CategoryFrontEntityMapper categoryFrontEntityMapper;

	private OldModelAdaptorCategoryFront adapt(final CategoryFrontEntity entity) {

		return new OldModelAdaptorCategoryFront(entity);
	}

	@Override
	public List<CategoryFront> getFirstCategory() {
		List<CategoryFrontEntity> categoryFrontEntity = categoryFrontEntityMapper.selectFirstLevel();
		List<CategoryFront> list = Lists.newArrayList();
		for (CategoryFrontEntity entity : categoryFrontEntity) {
			list.add(adapt(entity));
		}
		return list;
	}

	@Override
	public List<CategoryFront> getCategoriesByParentId(Integer parentId) {
		CategoryFrontEntityExample expample = new CategoryFrontEntityExample();
		CategoryFrontEntityExample.Criteria criteria = expample.createCriteria();
		if (parentId != null) {
			criteria.andParentIdEqualTo(Long.valueOf(parentId));
		} else {
			criteria.andIsLeafEqualTo(1);
			criteria.andInUseEqualTo(1);
		}

		List<CategoryFrontEntity> categoryFrontEntity = categoryFrontEntityMapper.selectByExample(expample);
		List<CategoryFront> list = Lists.newArrayList();
		for (CategoryFrontEntity entity : categoryFrontEntity) {
			list.add(adapt(entity));
		}
		return list;
	}

	@Override
	public List<CategoryFront> getCategoryFrontisById(List<Long> ids) {
		List<CategoryFront> list = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(ids)) {
			CategoryFrontEntityExample expample = new CategoryFrontEntityExample();
			CategoryFrontEntityExample.Criteria criteria = expample.createCriteria();
			criteria.andIdIn(ids);
			List<CategoryFrontEntity> categoryFrontEntity = categoryFrontEntityMapper.selectByExample(expample);
			for (CategoryFrontEntity entity : categoryFrontEntity) {
				list.add(adapt(entity));
			}
		}
		return list;
	}

	@Override
	public List<CategoryFront> getLeftCategorIdsByCodes(List<String> categoryCodes) {
		List<CategoryFrontEntity> categoryFrontEntity = categoryFrontEntityMapper.selectCategoryIds(categoryCodes);
		List<CategoryFront> list = Lists.newArrayList();
		for (CategoryFrontEntity entity : categoryFrontEntity) {
			list.add(adapt(entity));
		}
		return list;
	}

	@Override
	public List<String> getCategoryCodeBycode(List<String> categoryCodes) {
		return categoryFrontEntityMapper.selectCategoryCode(categoryCodes);
	}

	@Override
	public List<Long> getAllCategories() {
		return categoryFrontEntityMapper.getAllCategories();
	}

}
