package com.thebeastshop.pegasus.component.campaign.support;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;

import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.CampaignSectionProduct;
import com.thebeastshop.pegasus.component.campaign.ConditionType;
import com.thebeastshop.pegasus.component.campaign.FactorTypeEnum;

/**
 * @author Liang Wenjian
 */
public class DefaultCampaignSectionImpl implements CampaignSection {

	private Long id;
	private Long campaignId;
	private ConditionType conditionType;
	private BigDecimal line;
	private FactorTypeEnum factorType;
	private BigDecimal factor;
	private double ranking;
	private Integer temp;
	private List<CampaignSectionProduct> campaignSectionProducts;

	public DefaultCampaignSectionImpl() {
		super();
	}

	@Override
	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Long getCampaignId() {
		return campaignId;
	}

	public void setCampaignId(Long campaignId) {
		this.campaignId = campaignId;
	}

	@Override
	public ConditionType getConditionType() {
		return conditionType;
	}

	public void setConditionType(final ConditionType conditionType) {
		this.conditionType = conditionType;
	}

	@Override
	public BigDecimal getLine() {
		return line;
	}

	public void setLine(final BigDecimal line) {
		this.line = line;
	}

	public FactorTypeEnum getFactorType() {
		return factorType;
	}

	public void setFactorType(FactorTypeEnum factorType) {
		this.factorType = factorType;
	}

	@Override
	public BigDecimal getFactor() {
		return factor;
	}

	public void setFactor(final BigDecimal factor) {
		this.factor = factor;
	}

	@Override
	public List<CampaignSectionProduct> getCampaignSectionProducts() {
		return campaignSectionProducts;
	}

	public void setCampaignSectionProducts(final List<CampaignSectionProduct> campaignSectionProducts) {
		this.campaignSectionProducts = campaignSectionProducts;
	}

	@Override
	public double getRanking() {
		return ranking;
	}

	public void setRanking(double ranking) {
		this.ranking = ranking;
	}

	@Override
	public Integer getTemp() {
		return temp;
	}

	public void setTemp(Integer temp) {
		this.temp = temp;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof CampaignSection)) {
			return false;
		}
		final CampaignSection that = (CampaignSection) o;
		return this.conditionType.getId().equals(that.getConditionType().getId()) && this.line.compareTo(that.getLine()) == 0
			&& this.factorType.getId().equals(that.getFactorType().getId()) && this.factor.compareTo(that.getFactor()) == 0;
	}

	@Override
	public int hashCode() {
		return Objects.hash(getConditionType(), getLine(), getFactor());
	}

	@Override
	public String toString() {
		return "DefaultCampaignSectionImpl{" +
				"id=" + id +
				", campaignId=" + campaignId +
				", conditionType=" + conditionType +
				", line=" + line +
				", factorType=" + factorType +
				", factor=" + factor +
				", ranking=" + ranking +
				", temp=" + temp +
				", campaignSectionProducts=" + campaignSectionProducts +
				'}';
	}
}
