package com.thebeastshop.pegasus.component.campaign.support;

import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.LadderRuleEnum;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.support.mark.State;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;

/**
 * @author Liang Wenjian
 */
public class DefaultCampaignImpl implements Campaign {

	private Long id;									// 活动编号
	private String code;								// 活动编码
	private Integer version;							// 活动记录版本
	private Date createTime;							// 创建时间
	private String name;								// 活动名称
	private Date startTime;								// 开始时间
	private Date expireTime;							// 结束时间
	private ProductScope productScope;					// 适用商品范围
	private DiscountType discountType;					// 活动类型
    private Collection<AccessWayEnum> accessWays;			// 活动使用平台
    private Collection<MemberLevelEnum> memberLevels;	// 活动适用会员等级
	private String description;							// 活动描述
	private State state;								// 活动状态
	private List<CampaignSection> campaignSections;		// 活动优惠区间
	private Boolean cumulative;							// 活动是否可累计
	private List<Long> productIds;						// 适用商品
	private String productCode;							// 单商品活动的适用商品编码
	private Boolean temp;								// 当前记录是否为临时记录
	private Integer crossBorderFlag;					// 是否海淘
	private LadderRuleEnum ladderRule = LadderRuleEnum.ALL_LADDER; // 阶梯规则,默认全阶梯

	@Override
	public Long getId() {
		return id;
	}

	public void setId(final Long id) {
		this.id = id;
	}

	@Override
	public Date getCreateTime() {
		return createTime;
	}

	public void setCreateTime(final Date createTime) {
		this.createTime = createTime;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(final String name) {
		this.name = name;
	}

	@Override
	public Date getStartTime() {
		return startTime;
	}

	public void setStartTime(final Date startTime) {
		this.startTime = startTime;
	}

	@Override
	public Date getExpireTime() {
		return expireTime;
	}

	public void setExpireTime(final Date expireTime) {
		this.expireTime = expireTime;
	}

	@Override
	public ProductScope getProductScope() {
		return productScope;
	}

	public void setProductScope(final ProductScope productScope) {
		this.productScope = productScope;
	}

	@Override
	public DiscountType getDiscountType() {
		return discountType;
	}

	public void setDiscountType(final DiscountType discountType) {
		this.discountType = discountType;
	}

	@Override
	public String getDescription() {
		return description;
	}

	public void setDescription(final String description) {
		this.description = description;
	}

	public State getState() {
		return state;
	}

	public void setState(State state) {
		this.state = state;
	}

	@Override
	public List<CampaignSection> getCampaignSections() {
		return campaignSections;
	}

	public void setCampaignSections(final List<CampaignSection> campaignSections) {
		this.campaignSections = campaignSections;
	}

	@Override
	public Boolean isCumulative() {
		return cumulative;
	}

	public void setCumulative(final Boolean cumulative) {
		this.cumulative = cumulative;
	}

	@Override
	public List<Long> getProductIds() {
		return productIds;
	}

	public void setProductIds(List<Long> productIds) {
		this.productIds = productIds;
	}

	@Override
	public Integer getCrossBorderFlag() {
		return crossBorderFlag;
	}

	public void setCrossBorderFlag(Integer crossBorderFlag) {
		this.crossBorderFlag = crossBorderFlag;
	}

	@Override
	public boolean isExpired() {
		Date now = new Date();
		if (now.after(getExpireTime())) {
			return true;
		}
		return false;
	}

	@Override
	public boolean equals(final Object o) {
		if (this == o) {
			return true;
		}
		if (!(o instanceof Campaign)) {
			return false;
		}
		final Campaign that = (Campaign) o;
		return Objects.equals(getId(), that.getId());
	}

	@Override
	public int hashCode() {
		return Objects.hash(getId());
	}

	public void setCode(String code) {
		this.code = code;
	}

	public void setVersion(Integer version) {
		this.version = version;
	}

	@Override
	public String getCode() {
		return code;
	}

	@Override
	public Integer getVersion() {
		return version;
	}

    public void setAccessWays(Collection<AccessWayEnum> accessWays) {
        this.accessWays = accessWays;
    }

    public void setMemberLevels(Collection<MemberLevelEnum> memberLevels) {
        this.memberLevels = memberLevels;
    }

    @Override
	public String getProductCode() {
		return productCode;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	@Override
	public Boolean getTemp() {
		return temp;
	}

	public void setTemp(Boolean temp) {
		this.temp = temp;
	}

	public Boolean getCumulative() {
		return cumulative;
	}

	@Override
	public LadderRuleEnum getLadderRule() {
		return ladderRule;
	}

	public void setLadderRule(LadderRuleEnum ladderRule) {
		this.ladderRule = ladderRule;
	}

	@Override
	public String toString() {
		return "DefaultCampaignImpl{" +
				"id=" + id +
				", code='" + code + '\'' +
				", version=" + version +
				", createTime=" + createTime +
				", name='" + name + '\'' +
				", startTime=" + startTime +
				", expireTime=" + expireTime +
				", productScope=" + productScope +
				", discountType=" + discountType +
				", description='" + description + '\'' +
				", state=" + state +
				", campaignSections=" + campaignSections +
				", cumulative=" + cumulative +
				", productIds=" + productIds +
				", productCode='" + productCode + '\'' +
				", temp=" + temp +
				", crossBorderFlag=" + crossBorderFlag +
				'}';
	}
}
