package com.thebeastshop.pegasus.component.campaign.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.campaign.service.CampaignLimitService;
import com.thebeastshop.campaign.vo.CampaignStreamVO;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.cart.support.BuyQuota;
import com.thebeastshop.cart.support.DefaultProductPackImpl;
import com.thebeastshop.common.ServiceResp;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.CampaignHandler;
import com.thebeastshop.pegasus.component.campaign.CampaignResult;
import com.thebeastshop.pegasus.component.campaign.CampaignResult.DefaultCampaignResultImpl;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.CampaignSectionProduct;
import com.thebeastshop.pegasus.component.campaign.LadderRuleEnum;
import com.thebeastshop.pegasus.component.campaign.service.CampaignServiceNew;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.service.McPsSpvService;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.merchandise.vo.PsSpvVO;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.util.PriceUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 买赠、加价购活动，额外的商品如果限制了总数，则直接将其设置成一个新的商品？ TODO：没检查ownerId是否null
 *
 * @author Liang Wenjian
 */
@Service
public class CampaignServiceNewImpl implements CampaignServiceNew {

	private final Logger logger = LoggerFactory.getLogger(getClass());

	@Autowired
	private McPsSpvService mcPsSpvService;
	@Autowired
	private McPsProductService mcPsProductService;
	@Autowired
	private CampaignLimitService campaignLimitService;
    //private Map<ProductPack, BigDecimal> preFinalPriceMap;


    /**
	 * 活动操作器排序
	 *
	 * @param handlers
	 * @return
	 */
	private List<CampaignHandler> sortCampaignHandlers(List<CampaignHandler> handlers) {
		Collections.sort(handlers, new Comparator<CampaignHandler>() {
			@Override
			public int compare(CampaignHandler o1, CampaignHandler o2) {
				// 第一次比较折扣类型（价格折扣>满折（满减>满赠>加价购）
				Campaign campaign1 = o1.getCampaign();
				Campaign campaign2 = o2.getCampaign();
				DiscountType discountType1 = campaign1.getDiscountType();
				DiscountType discountType2 = campaign2.getDiscountType();
				int i = discountType1.getSort().compareTo(discountType2.getSort());
				if (i == 0) {
					// 第二次比较商品范围（单品>多品>全场）
					i = campaign1.getProductScope().getId().compareTo(campaign2.getProductScope().getId());
					if (i == 0) {
						// 第三次比较活动创建时间
						if (campaign1.getCreateTime() != null && campaign2.getCreateTime() != null) {
							i = campaign1.getCreateTime().compareTo(campaign2.getCreateTime());
						}
					}
				}
				return i;
			}
		});
		return handlers;
	}

	private CampaignResult handleOneCampaign(final CampaignHandler handler,
											 Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel,Map<String,PsProductVO> prodMap, Map<String, Boolean> cspLimitMap) {
		// 将原商品包列表分拆为参与的和不参与的
		Campaign campaign = handler.getCampaign();
		final List<ProductPack> participatingPacks = handler.getParticipatingPacks();
		final Collection<ProductPack> nonParticipatingPacks = handler.getNonParticipatingPacks();
		// logger.info("商品包分组结果：参与=" + participatingPacks + "，不参与=" +
		// nonParticipatingPacks);
		if (CollectionUtils.isEmpty(participatingPacks)) {
            // 没有购买活动商品
			return empty(campaign, nonParticipatingPacks, preFinalPriceMap);
		}
		// 将参与的商品包们拿去检查是否达标
		return checkCondition(campaign, participatingPacks, nonParticipatingPacks, preFinalPriceMap, channel, prodMap, cspLimitMap);
	}

	/**
	 * 将原商品包列表分拆为参与的和不参与的
	 *
	 * @param sourcePacks
	 * @param campaign
	 * @param participatingPacks
	 * @param nonParticipatingPacks
	 */
	// private void repartition(final Collection<? extends ProductPack>
	// sourcePacks, final Campaign campaign, //
	// final List<ProductPack> participatingPacks, final Collection<ProductPack>
	// nonParticipatingPacks) {
	// // 获取商品包对应的spv
	// List<Long> spvIds = Lists.newArrayList();
	// for (ProductPack pack : sourcePacks) {
	// spvIds.add(pack.getSpvId());
	// }
	// if (CollectionUtils.isNotEmpty(spvIds)) {
	// Map<Long, Spv> spvMap = spvService.map(spvIds);
	// // 若是自购商品包，对应的商品属于活动指定的商品，则放入“参与活动的商品包列表”中，否则放入“不参与的商品包列表”中；
	// // 若是赠品商品包，对应的商品不管是否属于活动指定商品，都放入“不参与的商品包列表”中；
	// //
	// 若是加价购商品包，对应的商品属于活动指定商品，则放入“参与活动的商品包列表”中，否则放入“不参与的商品包列表”中（需求：加价购商品只参与全场活动，这里就是全场活动）
	// if (campaign.getProductScope() == ProductScope.GLOBAL) {
	// for (final ProductPack pack : sourcePacks) {
	// // 需求：赠品不参与活动
	// final CartPackSource source = pack.getSource();
	// if (source == CartPackSource.GIFT) {
	// nonParticipatingPacks.add(pack);
	// } else if (source == CartPackSource.RAW || source ==
	// CartPackSource.CHEAPEN_OTHER) {
	// Spv spv = spvMap.get(pack.getSpvId());
	// if (campaignProductService.isParticipatingProduct(campaign,
	// spv.getProductId())) {
	// participatingPacks.add(pack);
	// } else {
	// nonParticipatingPacks.add(pack);
	// }
	// } else {
	// logger.error("CartPackSource目前只有三种，不可能到达这里");
	// throw new UnknownException();
	// }
	// }
	// } else {
	// for (final ProductPack pack : sourcePacks) {
	// // 需求：赠品不参与活动
	// // 需求：加价购商品不参与非全场活动。
	// final CartPackSource source = pack.getSource();
	// if (source == CartPackSource.RAW) {
	// Spv spv = spvMap.get(pack.getSpvId());
	// if (campaignProductService.isParticipatingProduct(campaign,
	// spv.getProductId())) {
	// participatingPacks.add(pack);
	// } else {
	// nonParticipatingPacks.add(pack);
	// }
	// } else if (source == CartPackSource.GIFT || source ==
	// CartPackSource.CHEAPEN_OTHER) {
	// nonParticipatingPacks.add(pack);
	// } else {
	// logger.error("CartPackSource目前只有三种，不可能到达这里");
	// throw new UnknownException();
	// }
	// }
	// }
	// }
	// }

	/**
	 * 获取满足的区间列表
	 *
	 * @param campaign
	 * @param price
	 * @param count
	 * @return
	 */
	private static List<CampaignSection> matchedConditionSections(final Campaign campaign, final BigDecimal price,
																  final int count) {
		final List<CampaignSection> campaignSections = campaign.getCampaignSections();
		final List<CampaignSection> rt = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(campaignSections)) {
			//TODO 获取所有满足活动的区间
			CampaignSection maxLineSection = null;
			for (CampaignSection campaignSection : campaignSections) {
				if (campaignSection.getConditionType().matchCondition(price, count, campaignSection.getLine())) {
					rt.add(campaignSection);
					if (maxLineSection == null || maxLineSection.getLine().compareTo(campaignSection.getLine()) == -1) {
						maxLineSection = campaignSection;
					}
				}
			}

			//是否阶梯优惠
			// 多阶梯规则 ：取最大满足
			if((!DiscountType.GIFT.equals(campaign.getDiscountType())&&!DiscountType.CHEAPEN_OTHER.equals(campaign.getDiscountType()))||LadderRuleEnum.MAX_LADDER.equals(campaign.getLadderRule())){
				if (maxLineSection != null) {
					rt.clear();
					rt.add(maxLineSection);
				}
			}
			Collections.sort(rt, CampaignSection.DESC);
		}
		return rt;
	}

	private static CampaignSection findFirstMatch(final Collection<CampaignSection> campaignSections,
												  final BigDecimal price, final int count) {
		for (final CampaignSection e : campaignSections) {
			if (e.getConditionType().matchCondition(price, count, e.getLine())) {
				return e;
			}
		}
		return null;
	}

	private CampaignResult checkCondition(final Campaign campaign, final List<ProductPack> participatingPacks,
										  final Collection<ProductPack> nonParticipatingPacks, Map<ProductPack, BigDecimal> preFinalPriceMap,
										  Channel channel,Map<String,PsProductVO> prodMap, Map<String, Boolean> cspLimitMap) {
		// 计算总价和总件数，看看是否符合活动要求
		BigDecimal participatingPrice = BigDecimal.ZERO;
		int participatingCount = 0;
		if (CollectionUtils.isNotEmpty(participatingPacks)) {
			for (final ProductPack productPack : participatingPacks) {
				participatingCount += productPack.getCount();
				final BigDecimal finalPrice = preFinalPriceMap.get(productPack);
				if (finalPrice == null) {// 此商品没有参与上一个活动
					participatingPrice = participatingPrice.add(productPack.getPrice());
				} else {
					participatingPrice = participatingPrice
							.add(finalPrice.multiply(BigDecimal.valueOf(productPack.getCount())));
				}
			}
		}
		participatingPrice = PriceUtil.keepToCent(participatingPrice);

		final List<CampaignSection> campaignSections = matchedConditionSections(campaign, participatingPrice,
				participatingCount);
		if (CollectionUtils.isEmpty(campaignSections)) {
            // 条件未满足
			return notReach(campaign, participatingPacks, nonParticipatingPacks, participatingPrice, participatingCount,
					preFinalPriceMap);
		}
		// 条件也满足，即参与了此活动，然后就操作活动影响
		return campaignAffect(campaign, participatingPrice, participatingCount, participatingPacks,
				nonParticipatingPacks, campaignSections, preFinalPriceMap, channel, prodMap, cspLimitMap);
	}

	/**
	 * 虽然购买了参与活动的商品，但未达标
	 *
	 * @param campaign
	 * @param participatePacks
	 * @param nonParticipatingPacks
	 * @param participatePrice
	 * @param participateCount
	 * @param preFinalPriceMap
	 * @return
	 */
	private static CampaignResult notReach(final Campaign campaign, final Collection<ProductPack> participatePacks,
										   final Collection<ProductPack> nonParticipatingPacks, final BigDecimal participatePrice,
										   final int participateCount, Map<ProductPack, BigDecimal> preFinalPriceMap) {
		return new DefaultCampaignResultImpl(campaign, false, participatePacks, participatePrice, preFinalPriceMap,
				preFinalPriceMap, nonParticipatingPacks, participatePrice, Lists.<ProductPack> newArrayList());
	}

	private static void addRawPriceToFinalPriceMap(final Map<ProductPack, BigDecimal> finalPriceMap,
												   final List<? extends ProductPack> packs) {
		for (final ProductPack pack : packs) {
			finalPriceMap.put(pack, pack.getFactProductPrice());
		}
	}

	private CampaignResult campaignAffect(final Campaign campaign, final BigDecimal participatingPrice,
										  final int participatingCount, final List<ProductPack> participatingPacks,
										  final Collection<ProductPack> nonParticipatingPacks, final List<CampaignSection> campaignSections,
										  final Map<ProductPack, BigDecimal> preFinalPriceMap, Channel channel,
                                          Map<String,PsProductVO> prodMap, Map<String, Boolean> cspLimitMap) {
		BigDecimal participatedPrice = participatingPrice;
		final Collection<ProductPack> additionalPacks = Lists.newArrayList();
		final Map<ProductPack, BigDecimal> finalPriceMap = Maps.newHashMap(preFinalPriceMap);

		final DiscountType discountType = campaign.getDiscountType();
		 
		// 区间和累积不能并存。所以如果有累积效果，就只取排在第一个的区间
		if (campaign.isCumulative()) {// 累积
			final CampaignSection campaignSection = findFirstMatch(campaignSections, participatingPrice,
					participatingCount);
			//购物车的优化 不循环调用service
			List<CampaignSection> campaignSections1 = new ArrayList<>();
			campaignSections1.add(campaignSection);

			assert campaignSection != null;
			// 满足条件的次数
			final int times = campaignSection.getConditionType().cumulate(campaignSection.getLine(), participatingPrice,
					participatingCount);
            // 强制参与，比如打折、买赠、满减
			if (discountType.isForceParticipate()) {
				// 影响价格，比如打折、满减
				if (discountType.isAffectPrice()) {
					participatedPrice = discountType.handlePrice(participatingPacks, campaignSection,
							participatingPrice, times, //
							finalPriceMap, preFinalPriceMap);
				}
				// 影响最终商品清单，比如买赠
				affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, prodMap, cspLimitMap);
			} else {
				// 非强制参与，比如加价购，所以不主动影响价格
				affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, prodMap, cspLimitMap);
			}
		} else {// 不累积
			boolean first = true;
			//Map<Long,PsProductVO>  psProductVOMap = findPsProductVOByCampaignIds(campaignSections,psSkuVOMap,presaleVOMap,warehouseMap,channel);
			for (final CampaignSection campaignSection : campaignSections) {
				// 在这里多区间可以是以下情况：买满100送a商品，买满200送b商品，买满300送c商品，可叠加，所以若买满300，则额外获得a、b、c。
				// 但一般多区间不会都影响价格，所以这里就按这样写了。最终只会采用第一个区间的价格策略
				final int times = 1;// 不累积意思=参与次数就是1次
				if (discountType.isForceParticipate()) {// 强制参与，比如打折、买赠、满减
					if (first) {
						first = false;
						// 影响价格，比如打折、满减
						if (discountType.isAffectPrice()) {
							participatedPrice = discountType.handlePrice(participatingPacks, campaignSection,
									participatingPrice, times, finalPriceMap, preFinalPriceMap);
						}
					}

					// 影响最终商品清单，比如买赠
					affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, prodMap, cspLimitMap);
				} else {
					// 非强制参与，比如加价购，所以不主动影响价格
					affectAdditionalPacks(campaign, additionalPacks, campaignSection, times, prodMap, cspLimitMap);
				}
			}
		}

		return new DefaultCampaignResultImpl(campaign, true, participatingPacks, participatingPrice, preFinalPriceMap,
				finalPriceMap, nonParticipatingPacks, participatedPrice, additionalPacks);
	}


	/**
	 * 通过活动中的商品ids 查询psProductVo 对象并重新设置psSpvVO 对象   解决一个service 重复调用的问题
	 * 优化购物车
	 * @Author lijing
	 * @param campaignSections 活动信息
	 * @param   psSkuVOMap skuVO
	 * @return
	 */
//	private Map<Long,PsProductVO> findPsProductVOByCampaignIds(List<CampaignSection> campaignSections,Map<String,PsSkuVO> psSkuVOMap,
//			Map<String,SPresaleVO> presaleVOMap,Map<String, SSkuStockVO> warehouseMap, Channel channel,Map<String,PsProductVO> prodMap){
//		// 方法步骤 1. 从活动集合中拿取所有的活动商品id
//		//           2.通过商品id 获取到所有的PsProductVO   并从所有的次对象获取所有的spvVOid信息
//		//           3. 通过spvIds 查询PsSpvVO 对象 并把次对象 设置到  商品里面PsProductVo对象中
//		Map<Long,PsProductVO> returnPsProductVOMap = new HashMap<>();//返回的vo对象
//
//		if (CollectionUtils.isNotEmpty(campaignSections)){
//			List<CampaignSectionProduct> campaignSectionProducts = new ArrayList<>();//活动中所有的商品信息
//			//List<String> additionalProductIds = new ArrayList<>();//所有的活动商品id
//			List<Long> productSpvIds = new ArrayList<>();//商品中所有的spvId
//			for (CampaignSection campaignSection : campaignSections){
//				campaignSectionProducts.addAll(campaignSection.getCampaignSectionProducts());
//			}
//			//得到所有的productId
//			
//			List<PsProductVO> psProductVOs = new ArrayList<>();
//			for(CampaignSectionProduct campaignSectionProduct : campaignSectionProducts){
//				//additionalProductIds.add(campaignSectionProduct.getAdditionalProductId()+"");
//				psProductVOs.add(prodMap.get(campaignSectionProduct.getAdditionalProductId()+""));
//			}
//			if(CollectionUtils.isNotEmpty(psProductVOs)) {
////				//走service查询出所有的PsProductVo的信息
////				PsProductCond psProductCond = new PsProductCond();
////				psProductCond.setIds(additionalProductIds);
////				psProductCond.setPagenum(additionalProductIds.size());
////				
////
////				psProductVOs.addAll(mcPsProductService.findByCond(psProductCond));
//				//得到所有的spvIds 查询PsSpvVO 对象
//				for (PsProductVO psProductVO : psProductVOs) {
//					for (PsSpvVO psSpvVO : psProductVO.getSpvList()) {
//						productSpvIds.add(psSpvVO.getSpvId());
//					}
//				}
//				if(CollectionUtils.isNotEmpty(productSpvIds)) {
//					//查询 PsSpvVo 对象
//					List<PsSpvVO> spvVOs = new ArrayList<>();
//					spvVOs.addAll(mcPsSpvService.findBySpvIdsWithStock(productSpvIds,channel.getCode()));
//					//将 spvVOs 设置到 psProductVO 中
//					convertPsProductVOs(psProductVOs, spvVOs, returnPsProductVOMap, psSkuVOMap, presaleVOMap, warehouseMap, channel.getWarehouseCode());
//				}
//			}
//		}
//
//		return returnPsProductVOMap;
//	}

	/**
	 * 功能 ： 将spvVOs 合并到psProductVOs 中
	 * @param psProductVOs productVo
	 * @param spvVOs    spvVOs
	 * @param returnPsProductVOMap  返回的Map对象
	 */
//	private void convertPsProductVOs (List<PsProductVO> psProductVOs,List<PsSpvVO> spvVOs, Map<Long,PsProductVO> returnPsProductVOMap,
//			Map<String,PsSkuVO> psSkuVOMap, Map<String,SPresaleVO> presaleVOMap,Map<String, SSkuStockVO> warehouseMap,String warehouseCode){
//		Long start = System.currentTimeMillis();
//		//1.将spv 转为map对象
//		Map<Long,PsSpvVO> spvVOMap = new HashMap<>();
//		List<String> skuCodes = new ArrayList<>();
//		for(PsSpvVO psSpvVO : spvVOs){
//			spvVOMap.put(psSpvVO.getSpvId(),psSpvVO);
//			//获取skuCode
//			if (psSpvVO.getCombined()) {
//				List<PsSkuCombinationVO> skuComns = psSpvVO.getSkuCombinationList();
//				if (CollectionUtils.isNotEmpty(skuComns)) {
//					for (PsSkuCombinationVO skuComn : skuComns) {
//						skuCodes.add(skuComn.getSubSkuCode());
//					}
//				}
//			} else {
//				skuCodes.add(psSpvVO.getSkuCode());
//			}
//		}
//		//查询psSpvVO对象
//		List<PsSkuVO> skus = mcPsSkuService.findBySkuCodes(skuCodes);
//		
//		
//		// 查预售
//		presaleVOMap.putAll(sPresaleService.findAvaliableBySkuCodes(skuCodes,false));
//		// 查实示库存
//		warehouseMap.putAll(sStockService.getSkuStocks(skuCodes,
//				warehouseCode));
//		for(PsSkuVO psSkuVO : skus){
//			psSkuVOMap.put(psSkuVO.getSkuCode(),psSkuVO);
//		}
//		for (PsProductVO psProductVO : psProductVOs){
//			List<PsSpvVO> psSpvVOs = new ArrayList<>();
//			for(PsSpvVO psSpvVO : psProductVO.getSpvList()){
//				PsSpvVO psSpvVOByMap = spvVOMap.get(psSpvVO.getSpvId());
//				if(null != psSpvVOByMap){
//					psSpvVOs.add(psSpvVOByMap);
//				}
//			}
//			if(CollectionUtils.isNotEmpty(psSpvVOs)){
//				psProductVO.setSpvList(psSpvVOs);
//			}
//			returnPsProductVOMap.put(Long.valueOf(psProductVO.getId()), psProductVO);
//		}
//	}




	/**
	 * 把额外获得的商品（只有一种）装袋。
	 *
	 * @param campaign
	 * @param additionalPacks
	 * @param campaignSection
	 */
	private void affectAdditionalPacks(final Campaign campaign, final Collection<ProductPack> additionalPacks,
									   final CampaignSection campaignSection, final int times,
                                       Map<String,PsProductVO> psProductVOMap, Map<String, Boolean> cspLimitMap) {
		final List<CampaignSectionProduct> campaignSectionProducts = campaignSection.getCampaignSectionProducts();
		if (CollectionUtils.isNotEmpty(campaignSectionProducts)) {

			// 根据商品id批量获取spv列表
			List<Long> productIds = Lists.newArrayList();
			for (CampaignSectionProduct temp : campaignSectionProducts) {
				productIds.add(temp.getAdditionalProductId());
			}

			for (int i = 0; i < campaignSectionProducts.size(); i++) {
				CampaignSectionProduct campaignSectionProduct = campaignSectionProducts.get(i);
				ProductPack additionalPack = checkCampaignSectionProduct(campaign, campaignSectionProduct, times, psProductVOMap, cspLimitMap);
				if (additionalPack == null) {
					continue;
				} else {
					additionalPacks.add(additionalPack);
					//break; 循环多商品
				}
			} // for
		}

	}

	/**
	 * 校验活动区间额外商品是否满足，并返回商品包
	 *
	 * @param campaign
	 * @param campaignSectionProduct
	 * @param times
	 * @return 满足返回初始化商品包 不满足返回null
	 */
	private ProductPack checkCampaignSectionProduct(Campaign campaign, CampaignSectionProduct campaignSectionProduct,
                                                    int times, Map<String, PsProductVO>  psProductVOMap, Map<String, Boolean> cspLimitMap) {
		final Long additionalProductId = campaignSectionProduct.getAdditionalProductId();
		final DiscountType discountType = campaign.getDiscountType();
		if (additionalProductId != null) {
			final PsProductVO additionalProduct = psProductVOMap.get(additionalProductId.toString());
			if (additionalProduct != null) {
				List<PsSpvVO> spvs = additionalProduct.getSpvList();
				if (CollectionUtils.isEmpty(spvs)) {
					throw new NoSuchResourceException("校验活动区间额外商品是否满足的方法出错了, 商品下面的spv都没有了", "productId",
							additionalProductId);
				}

				// 赠品和换购数量是否达到上限 true达到上限 false 未达上限
				Boolean limitFlag = false;
                Boolean cspLimit = cspLimitMap.get(campaign.getCode() + additionalProduct.getCode());
                if (cspLimit != null) {
                    limitFlag = cspLimit;
                }

				PsSpvVO maxStockSpv = spvs.get(0);
				Integer tempStock = 0;
				if(!limitFlag){
		
					for (PsSpvVO spv : spvs) {
						Integer stock = spv.getCanUseQuantity();
						if(stock>tempStock){
							tempStock = stock;
							maxStockSpv = spv;
						}
					}
				}

				if(tempStock > 0 || DiscountType.GIFT == discountType) {
					final DefaultProductPackImpl additionalPack = new DefaultProductPackImpl();
					additionalPack.setProductId(Long.valueOf(additionalProduct.getId()));
					additionalPack.setSpvId(maxStockSpv.getSpvId());
					//设置附加商品价格
					final BigDecimal additionalProductPrice = campaignSectionProduct
							.getAdditionalProductPrice();
					if (additionalProductPrice == null) {
						additionalPack.setFactProductPrice(additionalProduct.getListPrice());
					} else {
						additionalPack.setFactProductPrice(additionalProductPrice);
					}
					Integer maxCount = tempStock;
					Integer count = campaignSectionProduct.getLimitCount() == null?1:campaignSectionProduct.getLimitCount();
                    additionalPack.setLimitCount(count);
					//附加商品 可购买数量和默认购买数量
					if (count == -1) {
						count = 1 * times;
					} else {
						count = campaignSectionProduct.getLimitCount() * times;
						maxCount = count;
						if (count > tempStock) {
							count = tempStock;
						}
					}
					BuyQuota buyQuota = new BuyQuota(maxCount, maxCount, 0);
					if (discountType == DiscountType.GIFT) {
						additionalPack.setSource(CartPackSource.GIFT);
					} else if (discountType == DiscountType.CHEAPEN_OTHER) {
						additionalPack.setSource(CartPackSource.ADDIBLE);
						count=1;   //TODO 前段交互默认换购数量设置为1
					}
					// 购买限制为 -1 则限制购买限制为空
					if(campaignSectionProduct.getLimitCount() != null && campaignSectionProduct.getLimitCount() ==-1){
						buyQuota = null;
					}
					additionalPack.setBuyQuota(buyQuota);
					additionalPack.setCount(count);
					additionalPack.setSpv(maxStockSpv);
					additionalPack.setProduct(additionalProduct);
					return additionalPack;
				}
			} else {
				logger.warn("活动指定的额外商品" + additionalProductId + "不存在");
			}
		}
		return null;
	}

	/**
	 * 未购买活动商品。
	 *
	 * @param campaign
	 * @param nonParticipatingPacks
	 * @param preFinalPriceMap
	 * @return
	 */
	private static CampaignResult empty(final Campaign campaign, final Collection<ProductPack> nonParticipatingPacks,
										Map<ProductPack, BigDecimal> preFinalPriceMap) {
		return new DefaultCampaignResultImpl(campaign, false, Lists.<ProductPack> newArrayList(), BigDecimal.ZERO,
				preFinalPriceMap, preFinalPriceMap, nonParticipatingPacks, BigDecimal.ZERO,
				Lists.<ProductPack> newArrayList());
	}

	@Override
	public List<CampaignResult> match(List<CampaignHandler> handlers, List<? extends ProductPack> productPacks,
                                      Channel channel) {
        Date start = new Date();
        if (handlers.isEmpty()) {
        	return Collections.emptyList();
        }
        handlers = sortCampaignHandlers(handlers);
        final List<CampaignResult> rt = Lists.newArrayListWithExpectedSize(handlers.size());

        // 上一个活动的结果。由于活动效果可以叠加，所以活动针对的商品包必须是上一个活动的结果商品包
        List<? extends ProductPack> preResultPacks = productPacks;
        Map<ProductPack, BigDecimal> preFinalPriceMap = Maps.newHashMap();
        addRawPriceToFinalPriceMap(preFinalPriceMap, preResultPacks);


        if (CollectionUtils.isNotEmpty(handlers)) {
            // 解决循环调用外部连接
            List<String> prodIds = new ArrayList<>();
            Campaign campaign;
            List<CampaignSection> campaignSections;
            List<CampaignSectionProduct> campaignSectionProducts;
            List<Map<String, String>> cspList = Lists.newArrayList();
            Map<String, String> csp;
            String campaignCode;
            String additionalProductId;
            for (final CampaignHandler handler : handlers) {
                // 将原商品包列表分拆为参与的和不参与的
                campaign = handler.getCampaign();
                campaignCode = campaign.getCode();
                campaignSections = campaign.getCampaignSections();
                for (CampaignSection cs : campaignSections){
                   campaignSectionProducts =  cs.getCampaignSectionProducts();
                   for (CampaignSectionProduct campaignSectionProduct : campaignSectionProducts){
                       additionalProductId = String.valueOf(campaignSectionProduct.getAdditionalProductId());
                       if (!prodIds.contains(additionalProductId)) {
                           prodIds.add(additionalProductId);
                       }
                       csp = new HashMap<>(1);
                       csp.put(campaignCode, additionalProductId);
                       if (!cspList.contains(csp)) {
                           cspList.add(csp);
                       }
                   }
                }
            }


            Map<String,PsProductVO> prodMap =  mcPsProductService.mapByProdIds(prodIds);
            if (prodMap == null) {
            	
            	logger.error("取不到商品,prodIds:"+prodIds.toString());
            	
                prodMap = Maps.newHashMap();
            }

            List<Long> spvIds = Lists.newArrayList();

            //得到所有的spvIds 查询PsSpvVO 对象
            Long spvId;
            for (PsProductVO psProductVO : prodMap.values()) {
                for (PsSpvVO psSpvVO : psProductVO.getSpvList()) {
                    spvId = psSpvVO.getSpvId();
                    if (!spvIds.contains(spvId)) {
                        spvIds.add(spvId);
                    }
                }
                psProductVO.setSpvList(null);
            }

            if(CollectionUtils.isNotEmpty(spvIds)){
                List<PsSpvVO> spvs = mcPsSpvService.findBySpvIdsWithStock(spvIds,channel.getCode());
                List<PsSpvVO> spvVOs;
                PsProductVO vo;
                for(PsSpvVO spv : spvs){
                    vo = prodMap.get(String.valueOf(spv.getProductId()));
                    if (vo.getSpvList() == null) {
                        spvVOs = new ArrayList<>();
                        spvVOs.add(spv);
                        vo.setSpvList(spvVOs);
                    } else {
                        vo.getSpvList().add(spv);
                    }
                }
            }

            List<CampaignStreamVO> checkCspParams = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty(cspList)) {
                CampaignStreamVO cspParam;
                PsProductVO productVO;
                for (Map<String, String> cspMap : cspList) {
                    for (Map.Entry<String, String> entry : cspMap.entrySet()) {
                        cspParam = new CampaignStreamVO();
                        cspParam.setCampaignCode(entry.getKey());
                        productVO = prodMap.get(entry.getValue());
                        cspParam.setProductCode(productVO.getCode());
                        checkCspParams.add(cspParam);
                    }
                }
            }
            Map<String, Boolean> cspLimitMap = Maps.newHashMap();
            if (CollectionUtils.isNotEmpty(checkCspParams)) {
                ServiceResp<Map<String, Boolean>> serviceResp = campaignLimitService.checkCspLimit(checkCspParams);
                if (serviceResp.isFailure()) {
                    logger.error("查询活动额外商品限量信息出错");
                    throw new RuntimeException("campaignLimitService.checkCspLimit:"+serviceResp.getRespMsg());
                }
                cspLimitMap = serviceResp.getBean();
            }


            for (final CampaignHandler handler : handlers) {
                final CampaignResult campaignResult = handleOneCampaign(handler, preFinalPriceMap, channel, prodMap, cspLimitMap);

                final Collection<ProductPack> participators = campaignResult.getOwnedPacks();

                // 当前活动的结果商品包们。包括参加了此活动的商品包和没参加此活动的商品包，其中参加了的商品包可能已经发生变化。
                final List<ProductPack> curResultPacks = Lists.newArrayList(participators);
                if (CollectionUtils.isNotEmpty(preResultPacks)) {
                    for (final ProductPack preResultPack : preResultPacks) {
                        if (!participators.contains(preResultPack)) {
                            curResultPacks.add(preResultPack);
                        }
                    }
                }
                rt.add(campaignResult);
                preFinalPriceMap = campaignResult.getFinalPriceMap();
                preResultPacks = curResultPacks;
            }
        }
        Date end = new Date();
        logger.info("活动匹配花费时间：{}毫秒", end.getTime() - start.getTime());
        return rt;
    }
}
