package com.thebeastshop.pegasus.component.campaign;

import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.util.PriceUtil;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * Desc:价格影响因子类型(统一折扣、固定价格)枚举类
 *
 * Created by hafiz.zhang on 2016/9/6.
 */
public enum FactorTypeEnum implements HasIdGetter.HasIntIdGetter, HasName {

    DISCOUNT(1, "统一折扣"){
        @Override
        public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
            // 打折计算规格：price * (factor / 10)
            return PriceUtil.keepToCent(
                    basic.multiply(section.getFactor().divide(BigDecimal.valueOf(10), 2, RoundingMode.HALF_UP)));
        }
    },
    FIXED_AMOUNT(2, "固定价格"){
        @Override
        public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
            // 是固定价格类型, 价格变为固定值
            return section.getFactor();
        }
    },
    DIFFERENT_DISCOUNT(3, "不同折扣"){
        @Override
        public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
            // 是不同折扣类型, 计算规格：price * (factor / 10)
            return PriceUtil.keepToCent(
                    basic.multiply(section.getFactor().divide(BigDecimal.valueOf(10), 2, RoundingMode.HALF_UP)));
        }
    },
    DIFFERENT_AMOUNT(4, "不同价格"){
        @Override
        public BigDecimal calculate(BigDecimal basic, CampaignSection section) {
            // 是不同价格类型, 价格变为固定值
            return section.getFactor();
        }
    };

    private Integer id;
    private String name;

    FactorTypeEnum(Integer id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public Integer getId() {
        return id;
    }

    @Override
    public String getName() {
        return name;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public BigDecimal calculate(BigDecimal basic, final CampaignSection section){
        // 默认直接返回原价
        return basic;
    }

}
