package com.thebeastshop.pegasus.component.campaign;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignSectionProductImpl;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;
import com.thebeastshop.support.mark.HasRanking;

import java.math.BigDecimal;

/**
 * 活动门槛区间的商品。 由于一个区间里也可能有多商品，比如赠品，赠完一种之后改成另一种，所以本质上是一对多。
 * 目前仅买赠活动存在一对多，打折、满减、加价购暂时都不存在，但加价购是很有可能也搞出来的。
 *
 * @author Liang Wenjian
 */
@JsonDeserialize(as = DefaultCampaignSectionProductImpl.class)
public interface CampaignSectionProduct extends HasLongIdGetter, HasRanking {

	/**
	 * 对应的活动id
	 *
	 * @return
     */
	Long getCampaignId();

	/**
	 * 额外商品id
	 *
	 * @return
	 */
	Long getAdditionalProductId();

	/**
	 * 额外商品数量
	 *
	 * @return
	 */
	int getAdditionalProductCount();

	/**
	 * 额外商品执行的实际价格。
	 *
	 * @return
	 */
	BigDecimal getAdditionalProductPrice();

	/**
	 * 排序字段。值小者靠前。 使用处：对于赠品活动，可能有多个赠品，优先赠送赠品A，赠品A送完了再换成赠品B……此时就需要进行排序。
	 *
	 * @return
	 */
	@Override
	double getRanking();


	/**
	 * 获取是否为临时记录
	 * @return
	 */
	Integer getTemp();

	/**
	 * 获取额外商品的编码
	 *
	 * @return
	 */
	String getProductCode();

	/**
	 * 商品最大数量，换购最大换购数量、赠品赠送数量
	 * @return
	 */
	Integer getLimitCount();

}
