package com.thebeastshop.pegasus.component.campaign;

import java.util.List;

import com.thebeastshop.cart.ProductPack;;

/**
 * 
 * @author Paul-xiong
 *
 */
public interface CampaignHandler {

	// --------------------------活动部分

	Campaign getCampaign();

	// ---------------------商品包部分

	// -----------参与包

	/**
	 * 参与此活动的商品包。 注：是结果商品包，即包中的商品的属性（比如价格），是参与活动之后的结果。
	 *
	 * @return
	 */
	List<ProductPack> getParticipatingPacks();

	// ---------------未参与包

	/**
	 * 未参与活动的商品包（不包括额外包）
	 *
	 * @return
	 */
	List<ProductPack> getNonParticipatingPacks();

	// ============================================================

	class DefaultCampaignHandlerImpl implements CampaignHandler {
		private Campaign campaign;
		private List<ProductPack> participatingPacks;
		private List<ProductPack> nonParticipatingPacks;

		public DefaultCampaignHandlerImpl(final Campaign campaign, final List<ProductPack> participatingPacks,
				final List<ProductPack> nonParticipatingPacks) {
			this.campaign = campaign;
			this.participatingPacks = participatingPacks;
			this.nonParticipatingPacks = nonParticipatingPacks;
		}

		@Override
		public Campaign getCampaign() {
			return campaign;
		}

		@Override
		public List<ProductPack> getNonParticipatingPacks() {
			return nonParticipatingPacks;
		}

		@Override
		public List<ProductPack> getParticipatingPacks() {
			return participatingPacks;
		}

		@Override
		public String toString() {
			return getClass().getSimpleName() + hashCode() + ":{" + "campaign:" + campaign + ", participatingPacks:"
					+ getParticipatingPacks() + ", nonParticipatingPacks:" + getNonParticipatingPacks() + '}';
		}

	}
}
