package com.thebeastshop.pegasus.component.campaign;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.thebeastshop.pegasus.component.campaign.support.DefaultCampaignImpl;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.support.mark.HasCreateTime;
import com.thebeastshop.support.mark.HasIdGetter.HasLongIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.mark.HasState;
import com.thebeastshop.support.mark.State;
import com.thebeastshop.support.mark.WillExpire;

import java.util.List;

/**
 * 优惠活动
 *
 * @author Liang Wenjian
 */
@JsonDeserialize(as = DefaultCampaignImpl.class)
public interface Campaign extends HasLongIdGetter, HasName, HasCreateTime, WillExpire, HasState {
	/**
	 * 单商品活动/多商品活动/全场活动
	 *
	 * @return
	 */
	ProductScope getProductScope();

	/**
	 * 折扣类型
	 *
	 * @return
	 */
	DiscountType getDiscountType();

	/**
	 * 描述
	 *
	 * @return
	 */
	String getDescription();

	@Override
	State getState();

	/**
	 * 门槛区间
	 *
	 * @return
	 */
	List<CampaignSection> getCampaignSections();

	/**
	 * 操作是否可累积。 可累积表示：若商品多次满足活动条件，是否多次执行优惠。即满减活动的“上不封顶”；买赠活动的“赠品可累加”
	 *
	 * @return
	 */
	Boolean isCumulative();

	/**
	 * 获取适用商品编号集合
	 *
	 * @return
	 */
	List<Long> getProductIds();

	/**
	 * 获取活动编码
	 *
	 * @return
	 */
	String getCode();

	/**
	 * 获取活动记录版本
	 *
	 * @return
	 */
	Integer getVersion();

	/**
	 * 获取单商品活动的适用商品编码
	 * @return
	 */
	String getProductCode();

	/**
	 * 当前记录是否为临时记录
	 * @return
	 */
	Boolean getTemp();


	/**
	 * 获取是否为海淘
	 * @return
	 */
	Integer getCrossBorderFlag();

	/**
	 * 获取阶梯规则
	 * @return
	 */
	LadderRuleEnum getLadderRule();

}
