package com.thebeastshop.pegasus.component.announcement.service.impl;

import java.util.Date;
import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.google.common.collect.Lists;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.pegasus.component.announcement.Announcement;
import com.thebeastshop.pegasus.component.announcement.dao.mapper.AnnouncementEntityMapper;
import com.thebeastshop.pegasus.component.announcement.model.AnnouncementEntity;
import com.thebeastshop.pegasus.component.announcement.model.AnnouncementEntityExample;
import com.thebeastshop.pegasus.component.announcement.service.AnnouncementService;
import com.thebeastshop.pegasus.component.announcement.support.DefaultAnnouncementImpl;

/**
 * @author Liang Wenjian
 */
@Service
public class AnnouncementServiceImpl implements AnnouncementService {

	@Autowired
	private AnnouncementEntityMapper mapper;

	public AnnouncementServiceImpl() {
		super();
	}

	private Announcement entity2Domain(AnnouncementEntity entity) {
		if (entity != null) {
			final DefaultAnnouncementImpl domain = new DefaultAnnouncementImpl();
			domain.setLink(entity.getLink());
			domain.setTitle(entity.getTitle());
			return domain;
		}
		return null;
	}

	private List<Announcement> entity2Domain(List<AnnouncementEntity> entities) {
		List<Announcement> domains = Lists.newArrayList();
		if (CollectionUtils.isNotEmpty(entities)) {
			for (AnnouncementEntity entity : entities) {
				domains.add(entity2Domain(entity));
			}
		}
		return domains;
	}

	@Override
	public List<Announcement> getAvailable(final AccessWayEnum accessWay, final MemberLevelEnum memberLevel) {
		final Date now = new Date();
		final AnnouncementEntityExample example = new AnnouncementEntityExample();
		example.createCriteria().andAccessWayEqualTo(accessWay.getCode())//
				.andMemberLevelEqualTo(memberLevel.getCode())//
				.andStartTimeLessThanOrEqualTo(now)//
				.andEndTimeGreaterThan(now);
		final List<AnnouncementEntity> entities = mapper.selectByExample(example);
		return entity2Domain(entities);
	}
}
