package com.thebeastshop.pegasus.component.adaptor.luhan.service.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.adaptor.luhan.LuhanOrderVO;
import com.thebeastshop.pegasus.component.adaptor.luhan.dao.mapper.LuhanOrderMapper;
import com.thebeastshop.pegasus.component.adaptor.luhan.model.LuhanOrder;
import com.thebeastshop.pegasus.component.adaptor.luhan.model.LuhanOrderExample;
import com.thebeastshop.pegasus.component.adaptor.luhan.service.LuhanOrderService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by feilong.gao on 2017/1/6.
 */
@Service
public class LuhanOrderServiceImpl implements LuhanOrderService {

    @Autowired
    private LuhanOrderMapper mapper;

    @Override
    public List<LuhanOrderVO> findLuhanOrder(LuhanOrderVO luhanOrderVO) {
        LuhanOrderExample example = new LuhanOrderExample();
        LuhanOrderExample.Criteria criteria = example.createCriteria().andMemberIdEqualTo(luhanOrderVO.getMemberId());
        criteria.andStatusEqualTo(1);
        if(StringUtils.isNotEmpty(luhanOrderVO.getOrderCode())){
            criteria.andOrderCodeEqualTo(luhanOrderVO.getOrderCode());
        }
        if(!NumberUtil.isNullOrZero(luhanOrderVO.getSpvId())){
            criteria.andSpvIdEqualTo(luhanOrderVO.getSpvId());
        }
        List<LuhanOrder> list = mapper.selectByExample(example);
        return BeanUtil.buildListFrom(list,LuhanOrderVO.class);
    }

    @Override
    public boolean saveOrder(List<LuhanOrderVO> luhanOrderVOs) {
        if(CollectionUtils.isNotEmpty(luhanOrderVOs)){
            List<LuhanOrder> saves = BeanUtil.buildListFrom(luhanOrderVOs,LuhanOrder.class);
            for (LuhanOrder luhanOrder : saves){
                luhanOrder.setModifyTime(new Date());
                luhanOrder.setCreateTime(new Date());
                luhanOrder.setStatus(1);
                mapper.insert(luhanOrder);
            }
        }
        return true;
    }

    @Override
    public boolean saveOrder(LuhanOrderVO luhanOrderVO) {
        return this.saveOrder(Lists.<LuhanOrderVO>newArrayList(luhanOrderVO));
    }

    @Override
    public boolean delOrder(String orderCode) {
        LuhanOrder record = new LuhanOrder();
        record.setStatus(2);
        record.setModifyTime(new Date());
        LuhanOrderExample example = new LuhanOrderExample();
        example.createCriteria().andOrderCodeEqualTo(orderCode);
        int i = mapper.updateByExampleSelective(record,example);
        return true;
    }
}
