/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.ElementPool;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.PutTogetherUtil;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.RedElement;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;
import com.thebeastshop.support.vo.redenvelope.RedPrize;
import com.thebeastshop.support.vo.redenvelope.RedPrizePool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class SeparateRedUtil {
    private static Integer totalCutPrice = 400;
    private static Integer totalNum = 20;
    private static List<ElementPool> elementPools;
    private static Map<String, RedPrize> prizeMap;
    private static Integer poolSize;

    private static void init(RedEnvelopeConfig redEnvelopeConfig) {
        totalCutPrice = redEnvelopeConfig.getTotalCutPrice();
        totalNum = redEnvelopeConfig.getRedTotalNum();
        List redPools = redEnvelopeConfig.getRedPoolGroup();
        elementPools = SeparateRedUtil.getElementPools(redPools);
        SeparateRedUtil.setBoundary();
    }

    private static List<ElementPool> getElementPools(List<RedPrizePool> redPools) {
        if (null == prizeMap) {
            prizeMap = new HashMap<String, RedPrize>();
        }
        ArrayList result = Lists.newArrayList();
        for (RedPrizePool redPrizePool : redPools) {
            ElementPool elementPool = new ElementPool();
            elementPool.setMinEleCount(redPrizePool.getMinEleCount());
            elementPool.setTotalCount(redPrizePool.getTotalCount());
            List redPrizes = redPrizePool.getEles();
            ArrayList eles = Lists.newArrayList();
            for (RedPrize redPrize : redPrizes) {
                eles.add(new RedElement(redPrize.getRedValue(), redPrize.getCutPrice()));
                prizeMap.put(redPrize.getRedValue(), redPrize);
            }
            elementPool.setEles(eles);
            result.add(elementPool);
        }
        return result;
    }

    public static List<ElementPool> initElementPool() {
        ElementPool ep1 = new ElementPool();
        ep1.setMinEleCount(3);
        ep1.setTotalCount(16);
        ArrayList list = Lists.newArrayList((Object[])new RedElement[]{new RedElement("\u6ee1300\u51cf10", 10), new RedElement("\u6ee1300\u51cf11", 11), new RedElement("\u6ee1300\u51cf12", 12), new RedElement("\u6ee1300\u51cf15", 15), new RedElement("\u6ee1300\u51cf16", 16), new RedElement("\u6ee1300\u51cf17", 17), new RedElement("\u6ee1300\u51cf18", 18), new RedElement("\u6ee1300\u51cf19", 19), new RedElement("\u6ee1300\u51cf20", 20), new RedElement("\u6ee1300\u51cf21", 21), new RedElement("\u6ee1300\u51cf22", 22), new RedElement("\u6ee1300\u51cf23", 23), new RedElement("\u6ee1300\u51cf25", 25), new RedElement("\u6ee1300\u51cf26", 26), new RedElement("\u6ee1300\u51cf27", 27), new RedElement("\u6ee1300\u51cf28", 28), new RedElement("\u6ee1300\u51cf29", 29)});
        ep1.setEles(list);
        ElementPool ep2 = new ElementPool();
        ep2.setMinEleCount(1);
        ep2.setTotalCount(3);
        ArrayList list2 = Lists.newArrayList((Object[])new RedElement[]{new RedElement("\u6ee1500\u51cf30", 30), new RedElement("\u6ee1500\u51cf35", 35), new RedElement("\u6ee1500\u51cf40", 40), new RedElement("\u6ee1500\u51cf45", 45)});
        ep2.setEles(list2);
        ElementPool ep3 = new ElementPool();
        ep3.setMinEleCount(1);
        ep3.setTotalCount(1);
        ArrayList list3 = Lists.newArrayList((Object[])new RedElement[]{new RedElement("\u6ee1800\u51cf60", 60), new RedElement("\u6ee1800\u51cf80", 80), new RedElement("\u6ee11200\u51cf100", 100), new RedElement("\u6ee11200\u51cf120", 120)});
        ep3.setEles(list3);
        elementPools = Lists.newArrayList();
        elementPools.add(ep1);
        elementPools.add(ep2);
        elementPools.add(ep3);
        return elementPools;
    }

    private static void setBoundary() {
        if (CollectionUtils.isNotEmpty(elementPools)) {
            int ep3maxPrice;
            int ep3minPrice;
            int ep2maxPrice;
            for (ElementPool elementPool : elementPools) {
                SeparateRedUtil.setBundaryPrice(elementPool);
            }
            Collections.sort(elementPools);
            ElementPool ep1 = elementPools.get(0);
            ElementPool ep2 = elementPools.get(1);
            ElementPool ep3 = elementPools.get(2);
            int ep2minPrice = totalCutPrice - ep1.getMaxPrice() - ep3.getMaxPrice();
            if (ep2minPrice > ep2.getMinPrice()) {
                ep2.setMinPrice(ep2minPrice);
            }
            if ((ep2maxPrice = totalCutPrice - ep1.getMinPrice() - ep3.getMinPrice()) < ep2.getMaxPrice()) {
                ep2.setMaxPrice(ep2maxPrice);
            }
            if ((ep3minPrice = totalCutPrice - ep1.getMaxPrice() - ep2.getMaxPrice()) > ep3.getMinPrice()) {
                ep3.setMinPrice(ep3minPrice);
            }
            if ((ep3maxPrice = totalCutPrice - ep1.getMinPrice() - ep2.getMinPrice()) < ep3.getMaxPrice()) {
                ep3.setMaxPrice(ep3maxPrice);
            }
        }
    }

    private static void setBundaryPrice(ElementPool elementPool) {
        int maxPrice = 0;
        int minPrice = 0;
        int minEle = elementPool.getMinEleCount();
        int totalEle = elementPool.getTotalCount();
        List<RedElement> eles = elementPool.getEles();
        if (CollectionUtils.isNotEmpty(eles)) {
            maxPrice = eles.get(0).getValue() * (totalEle - minEle);
            minPrice = eles.get(eles.size() - 1).getValue() * (totalEle - minEle);
            for (int i = 0; i < minEle; ++i) {
                maxPrice += eles.get(i).getValue().intValue();
                minPrice += eles.get(eles.size() - 1 - i).getValue().intValue();
            }
        }
        elementPool.setMaxPrice(maxPrice);
        elementPool.setMinPrice(minPrice);
        SeparateRedUtil.setWeight(elementPool);
    }

    private static void setWeight(ElementPool elementPool) {
        int weight = elementPool.getEles().size() * elementPool.getTotalCount();
        elementPool.setWeight(weight);
    }

    public static List<ElementPool> getRedEles() {
        ElementPool ep1 = elementPools.get(0).getRandomElements();
        elementPools.get(0).getMaxPrice();
        ElementPool ep2 = null;
        int surplusAmount = 0;
        do {
            ep2 = elementPools.get(1).getRandomElements();
        } while ((surplusAmount = totalCutPrice - ep1.getTotalPrice() - ep2.getTotalPrice()) > elementPools.get(2).getMaxPrice() || surplusAmount < elementPools.get(2).getMinPrice());
        PutTogetherUtil putTogetherUtil = new PutTogetherUtil();
        putTogetherUtil.init(elementPools.get(2));
        ElementPool ep3 = putTogetherUtil.putTogether(elementPools.get(2), surplusAmount);
        ArrayList result = Lists.newArrayList((Object[])new ElementPool[]{ep1, ep2, ep3});
        return result;
    }

    public static RedEnvelopeConfig getSeparateRedConfig(RedEnvelopeConfig redEnvelopeConfig) {
        SeparateRedUtil.init(redEnvelopeConfig);
        List<ElementPool> result = SeparateRedUtil.getRedEles();
        ArrayList list = Lists.newArrayList();
        for (ElementPool elementPool : result) {
            for (RedElement redElement : elementPool.getEles()) {
                RedPrize redPrize = prizeMap.get(redElement.getName());
                redPrize.setNum(redElement.getNum());
                list.add(redPrize);
            }
        }
        redEnvelopeConfig.setRedGroup((List)list);
        return redEnvelopeConfig;
    }

    public static void main(String[] args) {
        SeparateRedUtil.initElementPool();
        Gson gson = new GsonBuilder().create();
        System.out.println("==========================step1 \u8bbe\u7f6e\u8fb9\u754c======>");
        SeparateRedUtil.setBoundary();
        System.out.println(gson.toJson(elementPools));
        System.out.println("==========================step3  \u62bd\u53d6\u7ea2\u5305======>");
        List<ElementPool> result = SeparateRedUtil.getRedEles();
        System.out.println("===========\u751f\u6210\u7ea2\u5305 =======>");
        System.out.println(gson.toJson(result));
        System.out.println("====================end =======>");
    }

    static {
        poolSize = 3;
    }
}

