/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.compatible.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.common.enums.AccessWayEnum;
import com.thebeastshop.common.enums.MemberLevelEnum;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.compatible.old.CategoryItemVo;
import com.thebeastshop.pegasus.component.compatible.old.ItemDo;
import com.thebeastshop.pegasus.component.compatible.old.ListConstant;
import com.thebeastshop.pegasus.component.compatible.old.ResponseVO2;
import com.thebeastshop.pegasus.component.compatible.service.ListService;
import com.thebeastshop.pegasus.component.product.enums.ProductSortField;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.merchandise.cond.PsMatchCampaignCond;
import com.thebeastshop.pegasus.merchandise.service.McPsProductService;
import com.thebeastshop.pegasus.merchandise.vo.PsChnStockVO;
import com.thebeastshop.pegasus.merchandise.vo.PsProductVO;
import com.thebeastshop.pegasus.util.comm.NullUtil;
import com.thebeastshop.support.page.Page;
import com.thebeastshop.support.page.Pagination;
import com.thebeastshop.support.page.Sort;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ListServiceImpl
implements ListService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private McPsProductService mcPsProductService;
    @Autowired
    private RedisService redisService;

    private List<PsProductVO> _callOldFindById(Long id, String channelCode, MemberVO member, AccessWayEnum accessWay) {
        List products = Lists.newArrayList();
        try {
            List list;
            ResponseVO2 responseVO;
            String url = ListConstant.FIND_LIST;
            HashMap params = Maps.newHashMap();
            params.put("currpage", 1);
            params.put("catid", id);
            params.put("pagenum", 1000);
            this.logger.info("\u63a5\u53e3\u540d={}", (Object)url);
            this.logger.info("\u53d1\u9001\u7684\u53c2\u6570 params={}", (Object)params);
            Date start = new Date();
            String resultStr = HttpUtil.doGet((String)url, (Map)params, (String)ListConstant.CHART_SET);
            Date end = new Date();
            this.logger.info("\u8bf7\u6c42\u5b98\u65b9\u670d\u52a1\u5668\u67e5\u8be2list\u5546\u54c1\u7684\u8bbf\u95ee\u65f6\u95f4\uff1a{}\u6beb\u79d2", (Object)(end.getTime() - start.getTime()));
            if (StringUtils.isNotBlank((String)resultStr) && null != (responseVO = (ResponseVO2)JsonUtil.alibabaToObject((String)resultStr, ResponseVO2.class)) && responseVO.isSuccess() && responseVO.getRetObj() != null && StringUtils.isNotBlank((String)responseVO.getRetObj().toString()) && CollectionUtils.isNotEmpty((Collection)(list = JsonUtil.alibabaToList((String)responseVO.getRetObj().toString(), CategoryItemVo.class)))) {
                final ArrayList productCodes = Lists.newArrayList();
                for (CategoryItemVo vo : list) {
                    ItemDo itemDo = vo.getItemDo();
                    if (itemDo == null || !StringUtils.isNotBlank((String)itemDo.getProductCode())) continue;
                    productCodes.add(itemDo.getProductCode());
                }
                MemberLevelEnum memberLevel = MemberLevelEnum.getEnumByCode((Integer)member.getMemberLevel());
                PsMatchCampaignCond cond = new PsMatchCampaignCond();
                cond.setMatchCampaign(Boolean.valueOf(true));
                cond.setAccessWay(accessWay.getCode());
                cond.setMemberLevel(memberLevel.getCode());
                cond.setDiscount(memberLevel.getLevelAmountCondition());
                products = this.mcPsProductService.findTopicByCodes(channelCode, (List)productCodes, cond, 1, productCodes.size());
                Collections.sort(products, new Comparator<PsProductVO>(){

                    @Override
                    public int compare(PsProductVO o1, PsProductVO o2) {
                        Integer i1 = this.getIndex(productCodes, o1);
                        Integer i2 = this.getIndex(productCodes, o2);
                        return i1.compareTo(i2);
                    }

                    private int getIndex(List<String> productCodes2, PsProductVO product) {
                        if (CollectionUtils.isNotEmpty(productCodes2)) {
                            for (int i = 0; i < productCodes2.size(); ++i) {
                                if (!productCodes2.get(i).equals(product.getCode())) continue;
                                return i;
                            }
                        }
                        return -1;
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5b98\u7f51\u83b7\u53d6list\u5546\u54c1\u5f02\u5e38:{}", (Throwable)e);
        }
        return products;
    }

    private List<PsProductVO> sort(List<PsProductVO> products, ProductSortField sortField, final String sortOrder) {
        switch (sortField) {
            case RELEASE: {
                if (!sortOrder.equalsIgnoreCase("ASC")) break;
                Collections.reverse(products);
                break;
            }
            case PRICE: {
                Collections.sort(products, new Comparator<PsProductVO>(){

                    @Override
                    public int compare(PsProductVO o1, PsProductVO o2) {
                        BigDecimal price2;
                        BigDecimal price1 = o1 != null && o1.getListPrice() != null ? o1.getListPrice() : BigDecimal.ZERO;
                        BigDecimal bigDecimal = price2 = o2 != null && o2.getListPrice() != null ? o2.getListPrice() : BigDecimal.ZERO;
                        if (sortOrder.equalsIgnoreCase("ASC")) {
                            return price1.compareTo(price2);
                        }
                        return price2.compareTo(price1);
                    }
                });
                break;
            }
        }
        return products;
    }

    private List<PsProductVO> sortBySoldOut(List<PsProductVO> products, String channelCode) {
        ArrayList hasInventory = Lists.newArrayList();
        ArrayList noInventory = Lists.newArrayList();
        block0: for (PsProductVO prod : products) {
            prod.setPicDetailMul("");
            List psChnStockVOs = prod.getStocks();
            for (PsChnStockVO psChnStockVO : psChnStockVOs) {
                if (!psChnStockVO.getChnCode().equalsIgnoreCase(channelCode)) continue;
                if (psChnStockVO.getStock() != null && psChnStockVO.getStock() > 0) {
                    hasInventory.add(prod);
                    continue block0;
                }
                noInventory.add(prod);
                continue block0;
            }
        }
        hasInventory.addAll(noInventory);
        return hasInventory;
    }

    @Override
    public Page<PsProductVO> findById(long id, int offset, int limit, ProductSortField sortField, String sortOrder, String channelCode, MemberVO member, AccessWayEnum accessWay) {
        Page rt = new Page(new Pagination(Integer.valueOf(offset), Integer.valueOf(limit), new Sort(sortField.getName(), sortOrder)));
        List<PsProductVO> list_pro = this.getListProduct(id, channelCode, sortField, sortOrder, member, accessWay);
        this.logger.info("\u67e5\u8be2List\u6570\u91cf" + list_pro.size());
        if (CollectionUtils.isNotEmpty(list_pro)) {
            int total = list_pro.size();
            rt.setTotal(Integer.valueOf(total));
            int fromIndex = offset;
            if (fromIndex < total) {
                int toIndex = offset + limit;
                if (toIndex > total) {
                    toIndex = total;
                }
                rt.setItems(list_pro.subList(fromIndex, toIndex));
            }
        } else {
            rt.setTotal(Integer.valueOf(0));
        }
        return rt;
    }

    private List<PsProductVO> getListProduct(long id, String channelCode, ProductSortField sortField, String sortOrder, MemberVO member, AccessWayEnum accessWay) {
        List<Object> products = Lists.newArrayList();
        String prodJson = this.redisService.get(this.getListProductRidisKey(id, channelCode, sortField, sortOrder, member, accessWay));
        if (NullUtil.isNull((Object)prodJson)) {
            List<PsProductVO> psProductVOs = this._callOldFindById(id, channelCode, member, accessWay);
            this.filterInvalidProds(psProductVOs, channelCode);
            List<PsProductVO> sortPsProd = this.sort(psProductVOs, sortField, sortOrder);
            products = this.sortBySoldOut(sortPsProd, channelCode);
            if (!CollectionUtils.isEmpty((Collection)products)) {
                this.redisService.set(this.getListProductRidisKey(id, channelCode, sortField, sortOrder, member, accessWay), JsonUtil.toJson((Object)products), 300);
                this.logger.info("\u52a0\u5165\u7f13\u5b58{},\u7f13\u5b58\u65f6\u95f4{}", (Object)this.getListProductRidisKey(id, channelCode, sortField, sortOrder, member, accessWay), (Object)"300\u79d2");
            } else {
                this.logger.info("\u52a0\u5165\u7f13\u5b58{} \u67e5\u8be2\u6570\u636e\u4e3a\u7a7a\u4e0d\u52a0\u5165\u7f13\u5b58", (Object)this.getListProductRidisKey(id, channelCode, sortField, sortOrder, member, accessWay));
            }
        } else {
            products = JsonUtil.alibabaToList((String)prodJson, PsProductVO.class);
            this.logger.info("\u53d6\u51fa\u7f13\u5b58key={}", (Object)this.getListProductRidisKey(id, channelCode, sortField, sortOrder, member, accessWay));
        }
        return products;
    }

    private void filterInvalidProds(List<PsProductVO> prods, String channelCode) {
        if (CollectionUtils.isNotEmpty(prods)) {
            Iterator<PsProductVO> prodIterators = prods.iterator();
            while (prodIterators.hasNext()) {
                PsProductVO product = prodIterators.next();
                if (CollectionUtils.isEmpty((Collection)product.getCanSeeSku(channelCode))) {
                    prodIterators.remove();
                    continue;
                }
                List onShelfChnCodes = product.getOnShelfChnCodes();
                if (!CollectionUtils.isEmpty((Collection)onShelfChnCodes) && onShelfChnCodes.contains(channelCode) && !CollectionUtils.isEmpty((Collection)product.getCanSaleSku(channelCode))) continue;
                prodIterators.remove();
            }
        }
    }

    private String getListProductRidisKey(long id, String channelCode, ProductSortField sortField, String sortOrder, MemberVO member, AccessWayEnum accessWay) {
        StringBuffer sb = new StringBuffer();
        sb.append("search_list_key_listId_").append(id).append(channelCode).append((Object)sortField).append(sortOrder).append(member.getMemberLevel()).append(accessWay);
        return sb.toString();
    }
}

