/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.logistics.service.impl;

import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.logistics.domain.fedex.FedexResponse;
import com.thebeastshop.pegasus.component.adaptor.logistics.service.FedexService;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.XmlUtil;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class FedexServiceImpl
extends BaseService
implements FedexService {
    private final String CHARSET = "UTF-8";

    @Override
    public FedexResponse queryByCode(String code) {
        if (StringUtils.isBlank((String)code)) {
            throw new WrongArgException("\u7269\u6d41\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a", "LogisticCode", (Object)code);
        }
        try {
            this.logger.info("\u67e5\u8be2\u8054\u90a6\u5feb\u9012\u7269\u6d41\u4fe1\u606f orderNo = {}", (Object)code);
            String url = "http://cndxp.apac.fedex.com/service/track/" + code;
            String dataStr = HttpUtil.doGet((String)url, null, (String)"UTF-8");
            this.logger.info("\u8054\u90a6\u5feb\u9012\u8fd4\u56de\u4fe1\u606f: {}", (Object)dataStr);
            FedexResponse response = new FedexResponse();
            response = (FedexResponse)XmlUtil.toObject((String)dataStr, FedexResponse.class);
            if (response.getTracking() != null && response.getTracking().getDetail() != null && response.getTracking().getDetail().getActivities() != null) {
                List<FedexResponse.FedexActivity> activities = response.getTracking().getDetail().getActivities().getActivity();
                Collections.sort(activities, new Comparator<FedexResponse.FedexActivity>(){

                    @Override
                    public int compare(FedexResponse.FedexActivity o1, FedexResponse.FedexActivity o2) {
                        return o2.getDatetime().compareTo(o1.getDatetime());
                    }
                });
                return response;
            }
        }
        catch (Exception e) {
            this.logger.info("\u67e5\u8be2\u8054\u90a6\u7269\u6d41\u5f02\u5e38 e={}", (Throwable)e);
        }
        return null;
    }
}

