/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.ElementPool;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.RedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class PutTogetherUtil {
    private ElementPool pool;
    private Map<Integer, RedElement> eleMap = new HashMap<Integer, RedElement>();
    private List<Integer> priceArray = Lists.newArrayList();
    private Map<Integer, Map<Integer, Integer>> matchTable = new HashMap<Integer, Map<Integer, Integer>>();
    private int maxDisparity;
    private Integer maxPrice;
    private Integer minPrice;
    private Integer averagePrice;

    public void init(ElementPool elementPool) {
        if (null != elementPool) {
            if (null == this.pool) {
                this.pool = elementPool;
            }
            for (RedElement ele : this.pool.getEles()) {
                this.eleMap.put(ele.getValue(), ele);
                this.priceArray.add(ele.getValue());
            }
            this.getMatchTable();
            this.getMaxDisparity();
        }
    }

    private void getMatchTable() {
        this.matchTable.clear();
        for (Integer i : this.priceArray) {
            for (int j = 1; j < this.priceArray.size(); ++j) {
                Integer a = i - this.priceArray.get(j);
                Map<Object, Object> map = null;
                if (this.matchTable.containsKey(a)) {
                    map = this.matchTable.get(a);
                    map.put(i, this.priceArray.get(j));
                    continue;
                }
                map = new HashMap<Integer, Integer>();
                map.put(i, this.priceArray.get(j));
                this.matchTable.put(a, map);
            }
        }
    }

    private void getMaxDisparity() {
        this.maxDisparity = this.priceArray.get(0) - this.priceArray.get(this.priceArray.size() - 1);
    }

    public ElementPool putTogether(ElementPool elementPool, Integer totalPrice) {
        int randomNum;
        if (null == this.pool) {
            this.init(elementPool);
        }
        int average = totalPrice / elementPool.getTotalCount();
        ArrayList gtAverage = Lists.newArrayList();
        ArrayList ltAverage = Lists.newArrayList();
        for (Integer price : this.priceArray) {
            if (price > average) {
                gtAverage.add(price);
                continue;
            }
            ltAverage.add(price);
        }
        int gtRandomNum = randomNum = elementPool.getTotalCount() / 2;
        int ltRandomNum = randomNum;
        if (randomNum * 2 != elementPool.getTotalCount()) {
            ++ltRandomNum;
        }
        List<Object> gtList = Lists.newArrayList();
        List<Object> ltList = Lists.newArrayList();
        Boolean flag = true;
        do {
            int i;
            gtList = this.getRandomList(gtAverage, gtRandomNum);
            ltList = this.getRandomList(ltAverage, ltRandomNum);
            int cutSum = this.getSum((List<Integer>)gtList) + this.getSum((List<Integer>)ltList);
            Integer dValue = cutSum - totalPrice;
            if (cutSum > totalPrice) {
                --gtRandomNum;
                ++ltRandomNum;
            } else if (cutSum < totalPrice) {
                ++gtRandomNum;
                --ltRandomNum;
            } else {
                flag = true;
            }
            if (!flag.booleanValue() || !this.matchTable.containsKey(dValue)) continue;
            Map<Integer, Integer> map = this.matchTable.get(dValue);
            for (i = 0; i < gtList.size(); ++i) {
                if (!map.containsKey(gtList.get(i))) continue;
                gtList.set(i, map.get(gtList.get(i)));
                flag = false;
                break;
            }
            for (i = 0; i < ltList.size(); ++i) {
                if (!map.containsKey(ltList.get(i))) continue;
                ltList.set(i, map.get(ltList.get(i)));
                flag = false;
                break;
            }
            if ((cutSum = this.getSum(gtList) + this.getSum(ltList)) == totalPrice) continue;
            flag = true;
        } while (flag.booleanValue());
        HashMap<Integer, Integer> eleNumMap = new HashMap<Integer, Integer>();
        for (Integer n : gtList) {
            if (eleNumMap.containsKey(n)) {
                eleNumMap.put(n, (Integer)eleNumMap.get(n) + 1);
                continue;
            }
            eleNumMap.put(n, 1);
        }
        for (Integer n : ltList) {
            if (eleNumMap.containsKey(n)) {
                eleNumMap.put(n, (Integer)eleNumMap.get(n) + 1);
                continue;
            }
            eleNumMap.put(n, 1);
        }
        ArrayList redEles = Lists.newArrayList();
        for (Map.Entry entery : eleNumMap.entrySet()) {
            RedElement redElement = this.eleMap.get(entery.getKey());
            redElement.setNum((Integer)entery.getValue());
            redEles.add(new RedElement(redElement));
        }
        ElementPool elementPool2 = new ElementPool(this.pool);
        elementPool2.setEles(redEles);
        return elementPool2;
    }

    private Integer getSum(List<Integer> list) {
        Integer sum = 0;
        for (Integer i : list) {
            sum = sum + i;
        }
        return sum;
    }

    private List<Integer> getRandomList(List<Integer> sources, Integer count) {
        ArrayList<Integer> targets = new ArrayList<Integer>();
        int i = sources.size();
        for (int j = 0; j < count; ++j) {
            int idx = new Random().nextInt(i);
            targets.add(sources.get(idx));
        }
        return targets;
    }
}

