/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.RedConfig;
import com.thebeastshop.pegasus.component.redenvelope.util.redenvelope.RedElement;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;
import com.thebeastshop.support.vo.redenvelope.RedPrize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.collections.CollectionUtils;

public class DivideRedUtil {
    private static List<List<Integer>> groups = Lists.newArrayList();
    private static List<Integer> redNumLimit = null;

    private void initRedNumLimit(RedConfig redConfig) {
        redNumLimit = Lists.newArrayListWithCapacity((int)redConfig.getRedElementList().size());
        List<RedElement> redElements = redConfig.getRedElementList();
        Integer a = 0;
        for (RedElement redElement : redElements) {
            a = a + redElement.getValue();
        }
        for (RedElement redElement : redElements) {
            redNumLimit.add((redConfig.getTotalCount() - a) / redElement.getValue() + 1);
        }
    }

    private static void initRedNumLimit(RedEnvelopeConfig redEnvelopeConfig) {
        redNumLimit = Lists.newArrayListWithCapacity((int)redEnvelopeConfig.getRedGroup().size());
        List redElements = redEnvelopeConfig.getRedGroup();
        Integer a = 0;
        for (RedPrize prize : redElements) {
            a = a + prize.getCutPrice();
        }
        for (RedPrize redElement : redElements) {
            redNumLimit.add((redEnvelopeConfig.getTotalCutPrice() - a) / redElement.getCutPrice() + 1);
        }
    }

    public List<List<Integer>> divideRed(RedConfig redConifg) {
        this.initRedNumLimit(redConifg);
        DivideRedUtil.split(null, redConifg.getTotalNum(), redConifg.getRedElementList().size());
        ArrayList redGroups = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(groups)) {
            for (List<Integer> r : groups) {
                if (!CollectionUtils.isNotEmpty(r)) continue;
                int b = 0;
                for (int i = 0; i < redConifg.getRedElementList().size(); ++i) {
                    b += r.get(i) * redConifg.getRedElementList().get(i).getValue();
                }
                if (b != redConifg.getTotalCount()) continue;
                redGroups.add(r);
            }
        }
        return redGroups;
    }

    public static RedEnvelopeConfig randomRedEnvelopeConfig(RedEnvelopeConfig config) {
        int i;
        DivideRedUtil.initRedNumLimit(config);
        int m = config.getRedTotalNum();
        int n = config.getRedGroup().size();
        DivideRedUtil.split(null, m, n);
        ArrayList redGroups = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(groups)) {
            for (List<Integer> r : groups) {
                if (!CollectionUtils.isNotEmpty(r)) continue;
                Integer b = 0;
                for (i = 0; i < n; ++i) {
                    b = b + r.get(i) * ((RedPrize)config.getRedGroup().get(i)).getCutPrice();
                }
                if (!b.equals(config.getTotalCutPrice())) continue;
                redGroups.add(r);
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)redGroups)) {
            int max = redGroups.size();
            int idx = 0;
            if (max > 1) {
                idx = new Random().nextInt(max);
            }
            List prizeNums = (List)redGroups.get(idx);
            for (i = 0; i < n; ++i) {
                ((RedPrize)config.getRedGroup().get(i)).setNum((Integer)prizeNums.get(i));
            }
        }
        return config;
    }

    private static int split(List<Integer> s, int m, int n) {
        List locs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(s)) {
            locs = Lists.newCopyOnWriteArrayList(s);
        }
        if (m < n) {
            return 1;
        }
        if (n == 1) {
            CopyOnWriteArrayList add = Lists.newCopyOnWriteArrayList((Iterable)locs);
            add.add(m);
            groups.add(add);
            return 1;
        }
        if (m == n) {
            CopyOnWriteArrayList add = Lists.newCopyOnWriteArrayList((Iterable)locs);
            for (int i = 1; i <= n; ++i) {
                add.add(1);
            }
            groups.add(add);
            return 1;
        }
        if (m > n) {
            int a = m - n + 1;
            for (int i = 1; i <= a; ++i) {
                CopyOnWriteArrayList add = Lists.newCopyOnWriteArrayList((Iterable)locs);
                add.add(i);
                DivideRedUtil.split(add, m - i, n - 1);
            }
        }
        return 0;
    }
}

