/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.redenvelope.business.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.redenvelope.business.IRedEnvelopeShareService;
import com.thebeastshop.pegasus.component.redenvelope.condition.RedEnvelopeCondition;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeDTO;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeRecordDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopePrizeGroup;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopePrizeGroupService;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeRecordService;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeService;
import com.thebeastshop.pegasus.component.redenvelope.util.RedEnveloperDivideUtil;
import com.thebeastshop.pegasus.component.support.Res;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import com.thebeastshop.support.enums.RedEnvelopeTemplateType;
import com.thebeastshop.support.enums.RedEnvelopeType;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.vo.NameValuePair;
import com.thebeastshop.support.vo.redenvelope.ReceiveDetailsVO;
import com.thebeastshop.support.vo.redenvelope.ReceivedRedEnvelopeVo;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeConfig;
import com.thebeastshop.support.vo.redenvelope.RedEnvelopeRecordVo;
import com.thebeastshop.support.vo.redenvelope.RedPrize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IRedEnvelopeShareServiceImpl
implements IRedEnvelopeShareService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    public RedEnvelopeService redEnvelopeService;
    @Autowired
    public RedEnvelopePrizeGroupService redEnvelopePrizeGroupService;
    @Autowired
    public RedEnvelopeRecordService redEnvelopeRecordService;

    @Override
    public Res<ReceiveDetailsVO> receiveRedEnvelope(MemberVO member, RedEnvelopeCondition condition) {
        this.logger.info("\u9886\u53d6\u7ea2\u5305\u5165\u53c2\uff1amember\uff1a{} \u9886\u53d6\u4fe1\u606f\uff1a{}", (Object)member, (Object)condition);
        Res<ReceiveDetailsVO> result = new Res<ReceiveDetailsVO>();
        ReceiveDetailsVO details = new ReceiveDetailsVO();
        RedEnvelopeDTO redEnvelopeDTO = this.redEnvelopeService.getRedEnveloper(Long.parseLong(condition.getShareId()));
        details.setAvailable(this.checkAavailable(redEnvelopeDTO));
        List<Object> list = Lists.newArrayList();
        if (redEnvelopeDTO == null) {
            this.logger.info("\u6d3b\u52a8id[{}]\u7684\u7ea2\u5305\u5206\u4eab\u6d3b\u52a8\u4e3a\u7a7a", (Object)condition.getShareId());
            result.setData(details);
            return result;
        }
        list = this.redEnvelopeRecordService.queryRecordByActivityId(condition.getShareId());
        details.setRecords(this.convertVo4Dto(list));
        Res<RedEnvelopeRecordVo> myReceivedRecord = this.getMyReceivedRecord(list, condition.getUnionId(), condition.getMobile());
        if (null != myReceivedRecord) {
            details.setMyReceived(myReceivedRecord.getData());
            result.setCode(myReceivedRecord.getCode());
            result.setMessage(myReceivedRecord.getMessage());
            details.setMyReceived(myReceivedRecord.getData());
            this.logger.info("\u5fae\u4fe1\u4f1a\u5458[{}]\u4e3a\u624b\u673a\u53f7[{}]\u5df2\u7ecf\u9886\u53d6\u7ea2\u5305\uff1a{}", new Object[]{condition.getUnionId(), condition.getMobile(), JSON.toJSONString(result)});
        } else if (details.isAvailable() && StringUtils.isNotEmpty((String)condition.getMobile())) {
            RedEnvelopePrizeGroup prizeGroup = this.getSharePrize(Long.parseLong(condition.getShareId()));
            Long prizeId = null;
            if (null != prizeGroup) {
                prizeId = prizeGroup.getId();
            }
            boolean flag = this.updateStock(Long.parseLong(condition.getShareId()), prizeId);
            this.logger.info("\u4fee\u6539\u7ea2\u5305\u6d3b\u52a8[{}],\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)condition.getShareId(), (Object)flag);
            if (flag) {
                RedEnvelopeRecordDTO saveRecord = new RedEnvelopeRecordDTO();
                saveRecord.setShareActivityId(condition.getShareId());
                if (null == prizeGroup) {
                    saveRecord.setReType(redEnvelopeDTO.getReType());
                    saveRecord.setReName(redEnvelopeDTO.getReName());
                    saveRecord.setReValue(redEnvelopeDTO.getReValue());
                    saveRecord.setReDesc(redEnvelopeDTO.getReDesc());
                } else {
                    saveRecord.setReType(prizeGroup.getReType());
                    saveRecord.setReName(prizeGroup.getReName());
                    saveRecord.setReValue(prizeGroup.getReValue());
                    saveRecord.setReDesc(prizeGroup.getReDesc());
                }
                saveRecord.setWechatHeadImg(condition.getAvatar());
                saveRecord.setWechatNickName(condition.getNickName());
                saveRecord.setWechatUnionid(condition.getUnionId());
                saveRecord.setReceiveMemberId(member.getId().toString());
                saveRecord.setReceiveMemberCode(member.getCode());
                saveRecord.setReceiveMobile(condition.getMobile());
                saveRecord = this.redEnvelopeRecordService.saveRedEnveloperRecord(saveRecord);
                this.logger.info("\u6dfb\u52a0\u7ea2\u5305\u9886\u53d6\u8bb0\u5f55\uff1a{}", (Object)JSON.toJSONString((Object)saveRecord));
                RedEnvelopeRecordVo myRecord = this.convertVo4Dto(saveRecord);
                myRecord.setFirstReceive(true);
                details.setMyReceived(myRecord);
                this.logger.info("\u5fae\u4fe1\u4f1a\u5458[{}]\u4e3a\u624b\u673a\u53f7[{}]\u9886\u53d6\u65b0\u7ea2\u5305 \u6210\u529f\uff1a{}", new Object[]{condition.getUnionId(), condition.getMobile(), JSON.toJSONString((Object)myRecord)});
            } else {
                details.setAvailable(false);
                this.logger.info("\u5fae\u4fe1\u4f1a\u5458[{}]\u4e3a\u624b\u673a\u53f7[{}]\u9886\u53d6\u65b0\u7ea2\u5305 \u5931\u8d25", (Object)condition.getUnionId(), (Object)condition.getMobile());
            }
        }
        result.setData(details);
        this.logger.info("\u9886\u53d6\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString(result));
        return result;
    }

    private RedEnvelopePrizeGroup getSharePrize(Long shareId) {
        RedEnvelopePrizeGroup result = null;
        List<RedEnvelopePrizeGroup> list = this.redEnvelopePrizeGroupService.getPrizeGroupByActiveId(shareId);
        ArrayList prizePool = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            for (RedEnvelopePrizeGroup prize : list) {
                if (prize.getReAmount() <= prize.getReleasedCount()) continue;
                for (int i = 0; i < prize.getReAmount() - prize.getReleasedCount(); ++i) {
                    prizePool.add(prize);
                }
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)prizePool)) {
            int max = prizePool.size();
            int idx = 0;
            if (max > 1) {
                idx = new Random().nextInt(max);
            }
            result = (RedEnvelopePrizeGroup)prizePool.get(idx);
        }
        return result;
    }

    @Transactional
    private boolean updateStock(Long shareId, Long prizeId) {
        boolean flag = this.redEnvelopeService.updateStock(shareId);
        this.logger.info("\u4fee\u6539\u7ea2\u5305\u6d3b\u52a8[{}],\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)shareId, (Object)flag);
        if (flag && !NumberUtil.isNullOrZero((Number)prizeId)) {
            flag = this.redEnvelopePrizeGroupService.updateStock(prizeId);
            this.logger.info("\u4fee\u6539\u7ea2\u5305\u6d3b\u52a8\u5956\u54c1[{}],\u5e93\u5b58\u7ed3\u679c\uff1a{}", (Object)prizeId, (Object)flag);
        }
        return flag;
    }

    private Res<RedEnvelopeRecordVo> getMyReceivedRecord(List<RedEnvelopeRecordDTO> records, String unionId, String mobile) {
        RedEnvelopeRecordVo myRecord = new RedEnvelopeRecordVo();
        Res<RedEnvelopeRecordVo> result = null;
        if (CollectionUtils.isNotEmpty(records)) {
            for (RedEnvelopeRecordDTO record : records) {
                if (record.getReceiveMobile().equalsIgnoreCase(mobile) && !record.getWechatUnionid().equalsIgnoreCase(unionId)) {
                    myRecord = this.convertVo4Dto(record);
                    result = new Res<RedEnvelopeRecordVo>(201, "\u624b\u673a\u5df2\u9886\u53d6\uff0c\u8bf7\u66f4\u6362\u624b\u673a\u53f7", myRecord);
                    break;
                }
                if (!record.getWechatUnionid().equalsIgnoreCase(unionId)) continue;
                myRecord = this.convertVo4Dto(record);
                result = new Res<RedEnvelopeRecordVo>();
                result.setData(myRecord);
                break;
            }
        }
        return result;
    }

    private boolean checkAavailable(RedEnvelopeDTO redEnvelopeDTO) {
        if (redEnvelopeDTO == null) {
            this.logger.info("\u7ea2\u5305\u5206\u4eab\u6d3b\u52a8\u4e0d\u5b58\u5728");
            return false;
        }
        if (redEnvelopeDTO.getReAmount() <= redEnvelopeDTO.getReleasedCount()) {
            this.logger.info("\u7ea2\u5305\u5df2\u7ecf\u9886\u53d6\u5b8c");
            return false;
        }
        Date date = new Date();
        if (redEnvelopeDTO.getStartTime() != null && redEnvelopeDTO.getStartTime().getTime() > date.getTime()) {
            this.logger.info("\u7ea2\u5305\u6d3b\u52a8\u6ca1\u6709\u5f00\u59cb");
            return false;
        }
        if (redEnvelopeDTO.getEndTime() != null && redEnvelopeDTO.getEndTime().getTime() < date.getTime()) {
            this.logger.info("\u7ea2\u5305\u6d3b\u52a8\u5df2\u7ecf\u7ed3\u675f");
            return false;
        }
        return true;
    }

    private RedEnvelopeRecordVo convertVo4Dto(RedEnvelopeRecordDTO sourceObj) {
        RedEnvelopeRecordVo targetObj = null;
        if (null != sourceObj) {
            targetObj = new RedEnvelopeRecordVo();
            targetObj.setAvatar(sourceObj.getWechatHeadImg());
            targetObj.setNickName(sourceObj.getWechatNickName());
            targetObj.setUnionId(sourceObj.getWechatUnionid());
            targetObj.setReceiveTime(sourceObj.getCreateTime());
            targetObj.setMobile(sourceObj.getReceiveMobile());
            ReceivedRedEnvelopeVo recordVo = new ReceivedRedEnvelopeVo();
            recordVo.setType(RedEnvelopeType.get((Integer)sourceObj.getReType()).getValue());
            recordVo.setDesc(sourceObj.getReDesc());
            recordVo.setValue(sourceObj.getReValue());
            recordVo.setName(sourceObj.getReName());
            targetObj.setReceived(recordVo);
        }
        return targetObj;
    }

    private List<RedEnvelopeRecordVo> convertVo4Dto(List<RedEnvelopeRecordDTO> sourceObjs) {
        ArrayList targetObjs = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(sourceObjs)) {
            for (RedEnvelopeRecordDTO sourceObj : sourceObjs) {
                targetObjs.add(this.convertVo4Dto(sourceObj));
            }
        }
        return targetObjs;
    }

    @Override
    @Transactional
    public Res<Long> createRedEnvelopeActivity(RedEnvelopeConfig config, MemberVO member, String bindId) {
        Res<Long> result = new Res<Long>();
        try {
            ArrayList prizes;
            this.checkRedEnvelopeConfig(config);
            RedEnvelopeDTO red = this.redEnvelopeService.getRedEnvelopeByOrder(bindId, member.getCode());
            if (null != red) {
                result.setData(red.getId());
                return result;
            }
            config = RedEnveloperDivideUtil.randomRedEnvelopeConfig(config);
            RedEnvelope redEnvelope = new RedEnvelope();
            redEnvelope.setType(config.getActivityType());
            redEnvelope.setBindId(bindId);
            redEnvelope.setReleasedCount(0);
            redEnvelope.setReAmount(config.getRedTotalNum());
            redEnvelope.setModifyTime(new Date());
            redEnvelope.setCreateTime(new Date());
            redEnvelope.setMemberCode(member.getCode());
            redEnvelope.setMemberId(member.getId().toString());
            redEnvelope.setTotalCutPrice(config.getTotalCutPrice());
            redEnvelope.setTemplateId(config.getTemplateId());
            redEnvelope.setTemplateType(config.getTemplateType());
            redEnvelope.setReType(config.getRedType());
            redEnvelope.setEndTime(config.getReEndTime());
            redEnvelope.setStartTime(config.getReStartTime());
            this.redEnvelopeService.newRedEnvelopeByOrder(redEnvelope);
            if (CollectionUtils.isNotEmpty((Collection)config.getRedGroup())) {
                prizes = Lists.newArrayList();
                for (RedPrize redPrize : config.getRedGroup()) {
                    RedEnvelopePrizeGroup prize = new RedEnvelopePrizeGroup();
                    prize.setModifyTime(new Date());
                    prize.setCreateTime(new Date());
                    prize.setReAmount(redPrize.getNum());
                    prize.setReCutPrice(redPrize.getCutPrice());
                    prize.setReValue(redPrize.getRedValue());
                    prize.setReDesc(redPrize.getRedDesc());
                    prize.setReName(redPrize.getRedName());
                    prize.setActivityId(redEnvelope.getId());
                    prize.setReType(config.getRedType());
                    prize.setReleasedCount(0);
                    prizes.add(prize);
                }
            } else {
                this.logger.error("config:{} \u5956\u54c1\u4e3a\u7a7a", (Object)JSON.toJSONString((Object)config));
                throw new WrongArgException("\u5956\u54c1\u4e3a\u7a7a", new NameValuePair[0]);
            }
            this.redEnvelopePrizeGroupService.addRedEnvelopePrizeGroup(prizes);
            result.setData(redEnvelope.getId());
        }
        catch (WrongArgException wae) {
            result.setCode(400);
            result.setMessage(wae.getMessage());
            return result;
        }
        return result;
    }

    boolean checkRedEnvelopeConfig(RedEnvelopeConfig config) {
        if (null == config) {
            throw new WrongArgException("\u7ea2\u5305\u914d\u7f6e\u4e3a\u7a7a\uff01\uff01\uff01", new NameValuePair[0]);
        }
        if (null == RedEnvelopeTemplateType.get((Integer)config.getTemplateType())) {
            throw new WrongArgException("\u7ea2\u5305\u6a21\u677f\u7c7b\u578b\u4e0d\u5408\u6cd5", new NameValuePair[0]);
        }
        if (NumberUtil.isNullOrZero((Number)config.getRedTotalNum())) {
            throw new WrongArgException("\u5206\u4eab\u7ea2\u5305\u603b\u6570\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
        }
        if (RedEnvelopeTemplateType.RANDOM_TEMPLATE.getCode().equals(config.getTemplateType()) && NumberUtil.isNullOrZero((Number)config.getTotalCutPrice())) {
            throw new WrongArgException("\u5206\u4eab\u7ea2\u5305\u968f\u673a\u7ea2\u5305\u603b\u503c\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
        }
        if (RedEnvelopeTemplateType.RANDOM_SEPARATE_TEMPLATE.getCode().equals(config.getTemplateType())) {
            if (CollectionUtils.isEmpty((Collection)config.getRedPoolGroup())) {
                throw new WrongArgException("\u5206\u4eab\u5206\u6863\u7ea2\u5305\u5956\u54c1\u6c60\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
            }
        } else if (CollectionUtils.isEmpty((Collection)config.getRedGroup())) {
            throw new WrongArgException("\u5206\u4eab\u7ea2\u5305\u5956\u54c1\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
        }
        if (null == RedEnvelopeType.get((Integer)config.getRedType())) {
            throw new WrongArgException("\u5206\u4eab\u7ea2\u5305\u5956\u54c1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
        }
        if (null == config.getReStartTime() || null == config.getReEndTime()) {
            throw new WrongArgException("\u5206\u4eab\u7ea2\u5305\u6d3b\u52a8\u7684\u7ed3\u675f\u65f6\u95f4\u548c\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", new NameValuePair[0]);
        }
        return true;
    }
}

