/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.discount;

import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.component.campaign.CampaignSection;
import com.thebeastshop.pegasus.component.campaign.FactorTypeEnum;
import com.thebeastshop.support.exception.BusinessLogicNotExpectedException;
import com.thebeastshop.support.mark.HasIdGetter;
import com.thebeastshop.support.mark.HasName;
import com.thebeastshop.support.util.PriceUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public enum DiscountType implements HasIdGetter.HasIntIdGetter,
HasName
{
    OFF(1, "\u4ef7\u683c\u6298\u6263", 1){

        @Override
        public boolean isAffectPrice() {
            return true;
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section) {
            FactorTypeEnum factorType = section.getFactorType();
            if (null != factorType) {
                return factorType.calculate(price, section);
            }
            throw new BusinessLogicNotExpectedException("\u4ef7\u683c\u5f71\u54cd\u56e0\u5b50\u7c7b\u578b\u9519\u8bef");
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section, int times) {
            return this.calculatePrice(price, section);
        }

        @Override
        public BigDecimal handlePrice(List<ProductPack> participatingPacks, CampaignSection campaignSection, BigDecimal participatingPrice, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
            BigDecimal participatedPrice = this.buildParticipatingPack(participatingPacks, campaignSection, times, finalPriceMap, preFinalPriceMap);
            return PriceUtil.keepToCent((BigDecimal)participatedPrice);
        }
    }
    ,
    CHEAPEN(2, "\u6ee1\u51cf", 2){

        @Override
        public boolean isAffectPrice() {
            return true;
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section) {
            return price.subtract(section.getFactor());
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section, int times) {
            return PriceUtil.keepToCent((BigDecimal)price.subtract(section.getFactor().multiply(BigDecimal.valueOf(times))));
        }

        @Override
        public BigDecimal handlePrice(List<ProductPack> participatingPacks, CampaignSection campaignSection, BigDecimal participatingPrice, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
            BigDecimal participatedPrice = this.calculatePrice(participatingPrice, campaignSection, times);
            BigDecimal savedRate = participatingPrice.subtract(participatedPrice).divide(participatingPrice, 10, RoundingMode.HALF_UP);
            for (ProductPack participatingPack : participatingPacks) {
                BigDecimal rawProductPrice = preFinalPriceMap.get(participatingPack);
                if (rawProductPrice == null) {
                    rawProductPrice = participatingPack.getFactProductPrice();
                }
                BigDecimal participatedProductPrice = PriceUtil.keepToCent((BigDecimal)rawProductPrice.subtract(rawProductPrice.multiply(savedRate)));
                finalPriceMap.put(participatingPack, participatedProductPrice);
            }
            return participatedPrice;
        }
    }
    ,
    DIC(5, "\u6ee1\u6298", 2){

        @Override
        public boolean isAffectPrice() {
            return true;
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section) {
            return PriceUtil.keepToCent((BigDecimal)price.multiply(section.getFactor().divide(BigDecimal.valueOf(10L), 2, RoundingMode.HALF_UP)));
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section, int times) {
            return this.calculatePrice(price, section);
        }

        @Override
        public BigDecimal handlePrice(List<ProductPack> participatingPacks, CampaignSection campaignSection, BigDecimal participatingPrice, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
            BigDecimal participatedPrice = this.buildParticipatingPack(participatingPacks, campaignSection, times, finalPriceMap, preFinalPriceMap);
            return PriceUtil.keepToCent((BigDecimal)participatedPrice);
        }
    }
    ,
    GIFT(3, "\u6ee1\u8d60", 3),
    CHEAPEN_OTHER(4, "\u6362\u8d2d", 4){

        @Override
        public boolean isForceParticipate() {
            return false;
        }
    }
    ,
    PANIC_BUY(6, "\u62a2\u8d2d", 0){

        @Override
        public boolean isAffectPrice() {
            return true;
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section) {
            FactorTypeEnum factorType = section.getFactorType();
            if (null != factorType) {
                return factorType.calculate(price, section);
            }
            throw new BusinessLogicNotExpectedException("\u4ef7\u683c\u5f71\u54cd\u56e0\u5b50\u7c7b\u578b\u9519\u8bef");
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section, int times) {
            return this.calculatePrice(price, section);
        }

        @Override
        public BigDecimal handlePrice(List<ProductPack> participatingPacks, CampaignSection campaignSection, BigDecimal participatingPrice, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
            BigDecimal participatedPrice = this.buildParticipatingPack(participatingPacks, campaignSection, times, finalPriceMap, preFinalPriceMap);
            return PriceUtil.keepToCent((BigDecimal)participatedPrice);
        }
    }
    ,
    OPTION(7, "N\u5143\u4efb\u9009", 2){

        @Override
        public boolean isAffectPrice() {
            return true;
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section) {
            return section.getFactor();
        }

        @Override
        public BigDecimal calculatePrice(BigDecimal price, CampaignSection section, int times) {
            return this.calculatePrice(price, section);
        }

        @Override
        public BigDecimal handlePrice(List<ProductPack> participatingPacks, CampaignSection campaignSection, BigDecimal participatingPrice, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
            BigDecimal participatedPrice = this.calculatePrice(participatingPrice, campaignSection, times);
            BigDecimal savedRate = participatingPrice.subtract(participatedPrice).divide(participatingPrice, 10, RoundingMode.HALF_UP);
            for (ProductPack participatingPack : participatingPacks) {
                BigDecimal rawProductPrice = preFinalPriceMap.get(participatingPack);
                if (rawProductPrice == null) {
                    rawProductPrice = participatingPack.getFactProductPrice();
                }
                BigDecimal participatedProductPrice = PriceUtil.keepToCent((BigDecimal)rawProductPrice.subtract(rawProductPrice.multiply(savedRate)));
                finalPriceMap.put(participatingPack, participatedProductPrice);
            }
            return participatedPrice;
        }
    };

    public final Integer id;
    public final String name;
    public final Integer sort;
    public static final List<DiscountType> ALL;

    private DiscountType(Integer id, String name, Integer sort) {
        this.id = id;
        this.name = name;
        this.sort = sort;
    }

    public boolean isForceParticipate() {
        return true;
    }

    public boolean isAffectPrice() {
        return false;
    }

    public BigDecimal calculatePrice(BigDecimal price, CampaignSection section) {
        return price;
    }

    public BigDecimal calculatePrice(BigDecimal price, CampaignSection section, int times) {
        return price;
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSort() {
        return this.sort;
    }

    public BigDecimal handlePrice(List<ProductPack> participatingPacks, CampaignSection campaignSection, BigDecimal participatingPrice, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
        for (ProductPack participatingPack : participatingPacks) {
            finalPriceMap.put(participatingPack, participatingPack.getFactProductPrice());
        }
        return participatingPrice;
    }

    protected BigDecimal buildParticipatingPack(List<ProductPack> participatingPacks, CampaignSection campaignSection, int times, Map<ProductPack, BigDecimal> finalPriceMap, Map<ProductPack, BigDecimal> preFinalPriceMap) {
        BigDecimal participatedPrice = BigDecimal.ZERO;
        if (null != campaignSection) {
            for (ProductPack participatingPack : participatingPacks) {
                BigDecimal rawPrice = preFinalPriceMap.get(participatingPack);
                if (rawPrice == null) {
                    rawPrice = participatingPack.getFactProductPrice();
                }
                BigDecimal participatedProductPrice = PriceUtil.keepToCent((BigDecimal)this.calculatePrice(rawPrice, campaignSection, times));
                finalPriceMap.put(participatingPack, participatedProductPrice);
                participatedPrice = participatedPrice.add(participatedProductPrice.multiply(BigDecimal.valueOf(participatingPack.getCount())));
            }
        } else {
            System.out.println("\u8b66\u544a    \u6298\u6263\u8ba1\u7b97\u4ef7\u683c  \u6d3b\u52a8\u4e3a\u7a7a ");
        }
        return participatedPrice;
    }

    static {
        ALL = Collections.unmodifiableList(Arrays.asList(DiscountType.values()));
    }
}

