/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.delivery.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.delivery.dao.DeliveryDistrictDao;
import com.thebeastshop.pegasus.component.delivery.dao.mapper.DeliveryDistrictEntityMapper;
import com.thebeastshop.pegasus.component.delivery.enums.DeliveryType;
import com.thebeastshop.pegasus.component.delivery.model.DeliveryDistrictEntity;
import com.thebeastshop.pegasus.component.delivery.model.DeliveryDistrictEntityExample;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class DeliveryDistrictDaoImpl
implements DeliveryDistrictDao {
    @Autowired
    private DeliveryDistrictEntityMapper mapper;

    @Override
    public List<Long> getDistrictIds(DeliveryType type) {
        ArrayList ids = Lists.newArrayList();
        if (type != null) {
            DeliveryDistrictEntityExample example = new DeliveryDistrictEntityExample();
            DeliveryDistrictEntityExample.Criteria criteria = example.createCriteria();
            criteria.andFlowerDevTypeEqualTo(type.getId().shortValue());
            criteria.andPcsTypeEqualTo(Byte.valueOf("3"));
            List<DeliveryDistrictEntity> entities = this.mapper.selectByExample(example);
            for (DeliveryDistrictEntity entity : entities) {
                ids.add(entity.getOeId());
            }
        }
        return ids;
    }

    @Override
    public List<Long> getDistrictIds(List<DeliveryType> types) {
        ArrayList ids = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(types)) {
            DeliveryDistrictEntityExample example = new DeliveryDistrictEntityExample();
            DeliveryDistrictEntityExample.Criteria criteria = example.createCriteria();
            ArrayList typeIds = Lists.newArrayList();
            for (DeliveryType type : types) {
                typeIds.add(type.getId().shortValue());
            }
            criteria.andFlowerDevTypeIn((List)typeIds);
            criteria.andPcsTypeEqualTo(Byte.valueOf("3"));
            List<DeliveryDistrictEntity> entities = this.mapper.selectByExample(example);
            for (DeliveryDistrictEntity entity : entities) {
                ids.add(entity.getOeId());
            }
        }
        return ids;
    }
}

