/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.category.dao.impl;

import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.category.CategoryFront;
import com.thebeastshop.pegasus.component.category.dao.CategoryFrontDao;
import com.thebeastshop.pegasus.component.category.dao.mapper.CategoryFrontEntityMapper;
import com.thebeastshop.pegasus.component.category.model.CategoryFrontEntity;
import com.thebeastshop.pegasus.component.category.model.CategoryFrontEntityExample;
import com.thebeastshop.pegasus.component.category.support.OldModelAdaptorCategoryFront;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class CategoryFrontDaoImpl
implements CategoryFrontDao {
    @Autowired
    private CategoryFrontEntityMapper categoryFrontEntityMapper;

    private OldModelAdaptorCategoryFront adapt(CategoryFrontEntity entity) {
        return new OldModelAdaptorCategoryFront(entity);
    }

    @Override
    public List<CategoryFront> getFirstCategory() {
        List<CategoryFrontEntity> categoryFrontEntity = this.categoryFrontEntityMapper.selectFirstLevel();
        ArrayList list = Lists.newArrayList();
        for (CategoryFrontEntity entity : categoryFrontEntity) {
            list.add(this.adapt(entity));
        }
        return list;
    }

    @Override
    public List<CategoryFront> getCategoriesByParentId(Integer parentId) {
        CategoryFrontEntityExample expample = new CategoryFrontEntityExample();
        CategoryFrontEntityExample.Criteria criteria = expample.createCriteria();
        if (parentId != null) {
            criteria.andParentIdEqualTo((long)parentId);
        } else {
            criteria.andIsLeafEqualTo(1);
            criteria.andInUseEqualTo(1);
        }
        List<CategoryFrontEntity> categoryFrontEntity = this.categoryFrontEntityMapper.selectByExample(expample);
        ArrayList list = Lists.newArrayList();
        for (CategoryFrontEntity entity : categoryFrontEntity) {
            list.add(this.adapt(entity));
        }
        return list;
    }

    @Override
    public List<CategoryFront> getCategoryFrontisById(List<Long> ids) {
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(ids)) {
            CategoryFrontEntityExample expample = new CategoryFrontEntityExample();
            CategoryFrontEntityExample.Criteria criteria = expample.createCriteria();
            criteria.andIdIn((List)ids);
            List<CategoryFrontEntity> categoryFrontEntity = this.categoryFrontEntityMapper.selectByExample(expample);
            for (CategoryFrontEntity entity : categoryFrontEntity) {
                list.add(this.adapt(entity));
            }
        }
        return list;
    }

    @Override
    public List<CategoryFront> getLeftCategorIdsByCodes(List<String> categoryCodes) {
        List<CategoryFrontEntity> categoryFrontEntity = this.categoryFrontEntityMapper.selectCategoryIds(categoryCodes);
        ArrayList list = Lists.newArrayList();
        for (CategoryFrontEntity entity : categoryFrontEntity) {
            list.add(this.adapt(entity));
        }
        return list;
    }

    @Override
    public List<String> getCategoryCodeBycode(List<String> categoryCodes) {
        return this.categoryFrontEntityMapper.selectCategoryCode(categoryCodes);
    }

    @Override
    public List<Long> getAllCategories() {
        return this.categoryFrontEntityMapper.getAllCategories();
    }
}

