/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.campaign;

import com.google.common.collect.Lists;
import com.thebeastshop.cart.ProductPack;
import com.thebeastshop.pegasus.component.campaign.Campaign;
import com.thebeastshop.pegasus.component.campaign.ProductScope;
import com.thebeastshop.pegasus.component.discount.DiscountType;
import com.thebeastshop.support.enums.CartPackSource;
import com.thebeastshop.support.util.PriceUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public interface CampaignResult {
    public Campaign getCampaign();

    public String getCampaignTitle();

    public DiscountType getDiscountType();

    public ProductScope getProductScope();

    public boolean isReach();

    public Map<ProductPack, BigDecimal> getOriginPriceMap();

    public Map<ProductPack, BigDecimal> getFinalPriceMap();

    public BigDecimal getRawPrice();

    public Collection<ProductPack> getOwnedPacks();

    public BigDecimal getOwnedPrice();

    public BigDecimal getSavedPrice();

    public Collection<ProductPack> getParticipatingPacks();

    public BigDecimal getParticipatedPrice();

    public BigDecimal getParticipatingPrice();

    public Collection<ProductPack> getNonParticipatingPacks();

    public Collection<ProductPack> getAdditionalPacks();

    public static class DefaultCampaignResultImpl
    implements CampaignResult {
        private final Campaign campaign;
        private final boolean reach;
        private final Map<ProductPack, BigDecimal> originPriceMap;
        private final Map<ProductPack, BigDecimal> finalPriceMap;
        private final Collection<ProductPack> participatingPacks;
        private final BigDecimal participatingPrice;
        private final Collection<ProductPack> nonParticipatingPacks;
        private final BigDecimal participatedPrice;
        private final Collection<ProductPack> additionalPacks;

        public DefaultCampaignResultImpl(Campaign campaign, boolean reach, Collection<ProductPack> participatingPacks, BigDecimal participatingPrice, Map<ProductPack, BigDecimal> originPriceMap, Map<ProductPack, BigDecimal> finalPriceMap, Collection<ProductPack> nonParticipatingPacks, BigDecimal participatedPrice, Collection<ProductPack> additionalPacks) {
            this.campaign = campaign;
            this.participatingPacks = participatingPacks;
            this.originPriceMap = originPriceMap;
            this.finalPriceMap = finalPriceMap;
            this.nonParticipatingPacks = nonParticipatingPacks;
            this.participatingPrice = participatingPrice;
            this.participatedPrice = participatedPrice;
            this.additionalPacks = additionalPacks;
            this.reach = reach;
        }

        @Override
        public Campaign getCampaign() {
            return this.campaign;
        }

        @Override
        public String getCampaignTitle() {
            return this.campaign.getDescription();
        }

        @Override
        public DiscountType getDiscountType() {
            return this.campaign.getDiscountType();
        }

        @Override
        public ProductScope getProductScope() {
            return this.campaign.getProductScope();
        }

        @Override
        public Collection<ProductPack> getNonParticipatingPacks() {
            return this.nonParticipatingPacks;
        }

        @Override
        public Collection<ProductPack> getParticipatingPacks() {
            return this.participatingPacks;
        }

        @Override
        public BigDecimal getParticipatingPrice() {
            return this.participatingPrice;
        }

        @Override
        public Map<ProductPack, BigDecimal> getOriginPriceMap() {
            return this.originPriceMap;
        }

        @Override
        public Map<ProductPack, BigDecimal> getFinalPriceMap() {
            return this.finalPriceMap;
        }

        @Override
        public BigDecimal getParticipatedPrice() {
            return this.participatedPrice;
        }

        @Override
        public Collection<ProductPack> getAdditionalPacks() {
            return this.additionalPacks;
        }

        @Override
        public boolean isReach() {
            return this.reach;
        }

        public String toString() {
            return this.getClass().getSimpleName() + this.hashCode() + ":{" + "campaign:" + this.campaign + ", reach:" + this.isReach() + ", participatingPacks:" + this.getParticipatingPacks() + ", participatingPrice:" + this.getParticipatingPrice() + ", finalPriceMap:" + this.getFinalPriceMap() + ", nonParticipatingPacks:" + this.getNonParticipatingPacks() + ", participatedPrice:" + this.getParticipatedPrice() + ", additionalPacks:" + this.getAdditionalPacks() + ", ownedPacks:" + this.getOwnedPacks() + ", ownedPrice:" + this.getOwnedPrice() + '}';
        }

        @Override
        public Collection<ProductPack> getOwnedPacks() {
            ArrayList rt = Lists.newArrayList(this.getParticipatingPacks());
            rt.addAll(this.getNonParticipatingPacks());
            Collection<ProductPack> additionalPacks = this.getAdditionalPacks();
            for (ProductPack productPack : additionalPacks) {
                if (productPack.getId() == null) continue;
                rt.add(productPack);
            }
            return rt;
        }

        @Override
        public BigDecimal getOwnedPrice() {
            Collection<ProductPack> ownedPacks = this.getOwnedPacks();
            Map<ProductPack, BigDecimal> finalPriceMap = this.getFinalPriceMap();
            BigDecimal rt = BigDecimal.ZERO;
            for (ProductPack ownedPack : ownedPacks) {
                if (ownedPack.getSource().equals((Object)CartPackSource.GIFT)) continue;
                BigDecimal finalPrice = finalPriceMap.get(ownedPack);
                if (finalPrice == null) {
                    rt = rt.add(ownedPack.getPrice());
                    continue;
                }
                rt = rt.add(finalPrice.multiply(BigDecimal.valueOf(ownedPack.getCount())));
            }
            return PriceUtil.keepToCent((BigDecimal)rt);
        }

        @Override
        public BigDecimal getSavedPrice() {
            return PriceUtil.keepToCent((BigDecimal)this.getParticipatingPrice().subtract(this.getParticipatedPrice()));
        }

        @Override
        public BigDecimal getRawPrice() {
            BigDecimal participatingPrice = this.getParticipatingPrice();
            Collection<ProductPack> nonParticipatingPacks = this.getNonParticipatingPacks();
            return PriceUtil.sumPrice(nonParticipatingPacks).add(participatingPrice);
        }
    }
}

