/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.tracking.service.impl;

import com.thebeastshop.pegasus.component.adaptor.tracking.GdtClickData;
import com.thebeastshop.pegasus.component.adaptor.tracking.dao.mapper.GdtClickDataEntityMapper;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.GdtClickDataEntity;
import com.thebeastshop.pegasus.component.adaptor.tracking.model.GdtClickDataEntityExample;
import com.thebeastshop.pegasus.component.adaptor.tracking.service.GdtClickDataService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.DateUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GdtClickDataServiceImpl
implements GdtClickDataService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private GdtClickDataEntityMapper gdtClickDataEntityMapper;

    @Override
    public boolean saveClickData(GdtClickData gdtClickData) {
        if (gdtClickData == null) {
            this.logger.warn("\u4fdd\u5b58\u5e7f\u70b9\u901a\u70b9\u51fb\u4fe1\u606f\uff1aGdtClickData is null");
        } else {
            this.logger.debug("saveClickData \u5165\u53c2\uff1a" + gdtClickData.toString());
            GdtClickDataEntity entity = (GdtClickDataEntity)BeanUtil.buildFrom((Object)gdtClickData, GdtClickDataEntity.class);
            this.gdtClickDataEntityMapper.insertSelective(entity);
        }
        return true;
    }

    @Override
    public GdtClickData queryByMuid(String muid) {
        if (muid == null) {
            this.logger.warn("\u67e5\u8be2\u6839\u636emuid[{}]\u67e5\u8be2\u5e7f\u70b9\u901a\u70b9\u51fb", (Object)muid);
        } else {
            GdtClickDataEntityExample example = new GdtClickDataEntityExample();
            GdtClickDataEntityExample.Criteria criteria = example.createCriteria();
            criteria.andMuidEqualTo(muid);
            criteria.andClickTimeGreaterThanOrEqualTo(DateUtil.addDay((Date)new Date(), (int)-7).getTime() / 1000L + "");
            example.setOrderByClause("id desc");
            List<GdtClickDataEntity> list = this.gdtClickDataEntityMapper.selectByExample(example);
            if (CollectionUtils.isNotEmpty(list)) {
                GdtClickData entity = (GdtClickData)BeanUtil.buildFrom((Object)list.get(0), GdtClickData.class);
                return entity;
            }
        }
        return null;
    }
}

