/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.adaptor.sns.config.WeiXinConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXJsTicket;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiXinService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import com.thebeastshop.support.encode.Sha1Util;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.NameValuePair;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeiXinServiceImpl
implements WeiXinService {
    private static final String CHARSET = "UTF-8";
    @Autowired
    private RedisService redisService;

    private String buildJsAccessTokenKey(String appId) {
        return "js_access_token-" + appId;
    }

    private String buildJsTicketKey(String access_token) {
        return "js_ticket-" + access_token;
    }

    private WXJsAccessToken getJsAccessToken(String appId, String secret) throws Exception {
        WXJsAccessToken accessToken = (WXJsAccessToken)this.redisService.get(this.buildJsAccessTokenKey(appId), (Type)((Object)WXJsAccessToken.class));
        if (accessToken == null) {
            String url = WeiXinConfig.JS_SDK_ACCESS_TOKEN_URL;
            HashMap params = Maps.newHashMap();
            params.put("grant_type", "client_credential");
            params.put("appid", appId);
            params.put("secret", secret);
            String dataStr = HttpUtil.doGet((String)url, (Map)params, (String)CHARSET);
            accessToken = (WXJsAccessToken)JsonUtil.toObject((String)dataStr, WXJsAccessToken.class);
            if (accessToken == null || StringUtils.isBlank((String)accessToken.getAccess_token())) {
                throw new NoSuchResourceException("\u83b7\u53d6\u5fae\u4fe1jssdk access token\u5931\u8d25!", "access token", (Object)dataStr);
            }
            this.redisService.set(this.buildJsAccessTokenKey(appId), accessToken, accessToken.getExpires_in().intValue() - 60);
        }
        return accessToken;
    }

    private WXJsTicket getJsTicket(String access_token) throws Exception {
        WXJsTicket ticket = (WXJsTicket)this.redisService.get(this.buildJsTicketKey(access_token), (Type)((Object)WXJsTicket.class));
        if (ticket == null) {
            String url = WeiXinConfig.JS_SDK_TICKET_URL;
            HashMap params = Maps.newHashMap();
            params.put("access_token", access_token);
            params.put("type", "jsapi");
            String dataStr = HttpUtil.doGet((String)url, (Map)params, (String)CHARSET);
            ticket = (WXJsTicket)JsonUtil.toObject((String)dataStr, WXJsTicket.class);
            if (ticket == null || !ticket.getErrcode().equals("0") || !ticket.getErrmsg().equals("ok")) {
                throw new NoSuchResourceException("\u83b7\u53d6\u5fae\u4fe1jssdk ticket\u5931\u8d25!", "ticket", (Object)dataStr);
            }
            this.redisService.set(this.buildJsTicketKey(access_token), ticket, ticket.getExpires_in().intValue() - 60);
        }
        return ticket;
    }

    @Override
    public WXAccessToken getAccessToken(String code) {
        WXAccessToken accessToken = null;
        StringBuilder url = new StringBuilder(WeiXinConfig.ACCESS_TOKEN_URL);
        String appId = WeiXinConfig.APP_ID;
        String secret = WeiXinConfig.SECRET;
        url.append("?").append("appid=").append(appId).append("&secret=").append(secret).append("&code=").append(code).append("&grant_type=authorization_code");
        try {
            String dataStr = HttpUtil.doGet((String)url.toString(), null, (String)CHARSET);
            accessToken = (WXAccessToken)JsonUtil.toObject((String)dataStr, WXAccessToken.class);
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
        if (accessToken == null || StringUtils.isBlank((String)accessToken.getAccess_token())) {
            throw new WrongArgException("\u83b7\u53d6\u5fae\u4fe1access_token\u5931\u8d25", new NameValuePair[0]);
        }
        return accessToken;
    }

    @Override
    public WXUserInfo getUserInfo(String accessToken, String openId) {
        WXUserInfo userInfo = null;
        StringBuilder url = new StringBuilder(WeiXinConfig.USER_INFO_URL);
        url.append("?").append("access_token=").append(accessToken).append("&openid=").append(openId);
        try {
            String dataStr = HttpUtil.doGet((String)url.toString(), null, (String)CHARSET);
            userInfo = (WXUserInfo)JsonUtil.toObject((String)dataStr, WXUserInfo.class);
        }
        catch (Exception e) {
            throw new UnknownException(e.getMessage());
        }
        if (userInfo == null || StringUtils.isBlank((String)userInfo.getUnionid())) {
            throw new WrongArgException("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237\u4fe1\u606f\u5931\u8d25", new NameValuePair[0]);
        }
        return userInfo;
    }

    @Override
    public WXJsConfig getJsConfig(String url, String accessToken) {
        try {
            String appId = WeiXinConfig.APP_ID2;
            Long timestamp = System.currentTimeMillis() / 1000L;
            String noncestr = StringUtil.getRandomString((int)16);
            WXJsTicket ticket = this.getJsTicket(accessToken);
            HashMap params = Maps.newHashMap();
            params.put("noncestr", noncestr);
            params.put("jsapi_ticket", ticket.getTicket());
            params.put("timestamp", timestamp);
            params.put("url", url);
            String signature = Sha1Util.sha1ToHexString((Map)params);
            return new WXJsConfig(appId, timestamp, noncestr, signature);
        }
        catch (Exception e) {
            throw new UnknownException((Throwable)e);
        }
    }

    public static void main(String[] args) {
    }
}

