/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.adaptor.sns.config.WeChatAppletConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WeChatAppletToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WeChatAppletUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeChatAppletService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiXinService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.support.exception.NoSuchResourceException;
import com.thebeastshop.support.exception.UnknownException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.util.Base64;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WeChatAppletServiceImpl
implements WeChatAppletService {
    private static final String CHARSET = "UTF-8";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private RedisService redisService;
    @Autowired
    private WeiXinService weixinService;
    String appId = WeChatAppletConfig.APP_ID;
    String appSecret = WeChatAppletConfig.SECRET;
    public static final String KEY_ALGORITHM = "AES";
    public static final String KEY_NAME = "AES";
    public static final String CIPHER_ALGORITHM = "AES/CBC/PKCS7Padding";

    private String buildSessionKey(String appId) {
        return "weChatApplet_sessionKey-" + appId;
    }

    private WeChatAppletToken getSession_key(String code) throws Exception {
        String url = WeChatAppletConfig.SESSION_KEY_URL;
        HashMap params = Maps.newHashMap();
        params.put("appid", this.appId);
        params.put("secret", this.appSecret);
        params.put("js_code", code);
        params.put("grant_type", "client_credential");
        String dataStr = "";
        dataStr = HttpUtil.doGet((String)url, (Map)params, (String)CHARSET);
        WeChatAppletToken sessionKey = (WeChatAppletToken)JsonUtil.toObject((String)dataStr, WeChatAppletToken.class);
        if (sessionKey == null || StringUtils.isBlank((String)sessionKey.getSession_key())) {
            throw new NoSuchResourceException("\u83b7\u53d6\u5fae\u4fe1\u5c0f\u7a0b\u5e8fsession_key\u5931\u8d25!", "session_key", (Object)dataStr);
        }
        return sessionKey;
    }

    private boolean signatureValidation(String sessionKey, String rawData, String signature) throws Exception {
        Boolean status = false;
        StringBuffer sb = new StringBuffer(rawData);
        sb.append(sessionKey);
        String encryData = DigestUtils.sha1Hex((String)sb.toString());
        if (!encryData.equals(signature)) {
            throw new NoSuchResourceException("\u7b7e\u540d\u6821\u9a8c\u5931\u8d25\uff01", "signature", (Object)signature);
        }
        status = true;
        return status;
    }

    private WeChatAppletUserInfo decodeEncryptedData(String encryptedData, String iv, String sessionKey) throws Exception {
        WeChatAppletUserInfo wxInfo = new WeChatAppletUserInfo();
        String json = WeChatAppletServiceImpl.wxDecrypt(encryptedData, sessionKey, iv);
        System.out.println(json);
        wxInfo = (WeChatAppletUserInfo)JsonUtil.toObject((String)json, WeChatAppletUserInfo.class);
        if (wxInfo == null) {
            throw new NoSuchResourceException("\u7528\u6237\u4fe1\u606f\u89e3\u5bc6\u5931\u8d25!", "unionId", (Object)wxInfo);
        }
        this.logger.debug("\u83b7\u53d6\u5fae\u4fe1\u7528\u6237unionId{}" + wxInfo.getUnionId());
        return wxInfo;
    }

    @Override
    public WeChatAppletUserInfo getUserInfo(String rawData, String encryptedData, String iv, String signature, String code) {
        WeChatAppletUserInfo userInfo = new WeChatAppletUserInfo();
        try {
            boolean status;
            WeChatAppletToken token = this.getSession_key(code);
            String avatarUrl = "";
            if (StringUtils.isNotBlank((String)rawData)) {
                JSONObject jsonData = JSONObject.parseObject((String)rawData);
                avatarUrl = jsonData.getString("avatarUrl");
            }
            if (status = this.signatureValidation(token.getSession_key(), rawData, signature)) {
                userInfo = this.decodeEncryptedData(encryptedData, iv, token.getSession_key());
                userInfo.setAvatarUrl(avatarUrl);
            }
        }
        catch (Exception e) {
            throw new UnknownException((Throwable)e);
        }
        return userInfo;
    }

    public static String wxDecrypt(String encrypted, String session_key, String iv) {
        String json = null;
        byte[] encrypted64 = Base64.decodeBase64((String)encrypted);
        byte[] key64 = Base64.decodeBase64((String)session_key);
        byte[] iv64 = Base64.decodeBase64((String)iv);
        try {
            WeChatAppletServiceImpl.init();
            json = new String(WeChatAppletServiceImpl.decrypt(encrypted64, key64, WeChatAppletServiceImpl.generateIV(iv64)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    public static void init() throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        KeyGenerator.getInstance("AES").init(128);
    }

    public static AlgorithmParameters generateIV(byte[] iv) throws Exception {
        AlgorithmParameters params = AlgorithmParameters.getInstance("AES");
        params.init(new IvParameterSpec(iv));
        return params;
    }

    public static byte[] decrypt(byte[] encryptedData, byte[] keyBytes, AlgorithmParameters iv) throws Exception {
        int base = 16;
        if (keyBytes.length % base != 0) {
            int groups = keyBytes.length / base + (keyBytes.length % base != 0 ? 1 : 0);
            byte[] temp = new byte[groups * base];
            Arrays.fill(temp, (byte)0);
            System.arraycopy(keyBytes, 0, temp, 0, keyBytes.length);
            keyBytes = temp;
        }
        SecretKeySpec key = new SecretKeySpec(keyBytes, "AES");
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        cipher.init(2, (Key)key, iv);
        return cipher.doFinal(encryptedData);
    }
}

