/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.sns.service.impl;

import com.thebeastshop.pegasus.component.adaptor.sns.config.QQConfig;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.QQUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.QQService;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.vo.NameValuePair;
import java.util.HashMap;
import org.springframework.stereotype.Service;

@Service
public class QQServiceImpl
implements QQService {
    private static final String CHARSET = "UTF-8";

    @Override
    public QQUserInfo getSimpleUserInfo(String accessToken, String openId, String platform) {
        QQUserInfo userInfo = null;
        StringBuilder url = new StringBuilder(QQConfig.getSimpleUserInfoUrl());
        String appId = "";
        if (platform == null) {
            throw new WrongArgException("\u5e73\u53f0\u53c2\u6570\u4e0d\u6b63\u786e", new NameValuePair[0]);
        }
        if (platform.toLowerCase().contains("ios")) {
            appId = QQConfig.getAppIdForIOS();
        } else if (platform.toLowerCase().contains("android")) {
            appId = QQConfig.getAppIdForAndroid();
        } else {
            throw new WrongArgException("\u5e73\u53f0\u53c2\u6570\u4e0d\u6b63\u786e", new NameValuePair[0]);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("access_token", accessToken);
        params.put("oauth_consumer_key", appId);
        params.put("openid", openId);
        try {
            String dataStr = HttpUtil.doGet((String)url.toString(), params, (String)CHARSET);
            userInfo = (QQUserInfo)JsonUtil.toObject((String)dataStr, QQUserInfo.class);
        }
        catch (Exception e) {
            throw new UnknownError(e.getMessage());
        }
        return userInfo;
    }
}

