/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.sns;

import com.thebeastshop.pegasus.component.adaptor.sns.domain.QQUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WBUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXAccessToken;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WXUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.domain.WeChatAppletUserInfo;
import com.thebeastshop.pegasus.component.adaptor.sns.service.QQService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeChatAppletService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiBoService;
import com.thebeastshop.pegasus.component.adaptor.sns.service.WeiXinService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;
import com.thebeastshop.pegasus.util.lock.PegasusFacadeLock;
import org.springframework.beans.factory.annotation.Autowired;

public class PegasusSnsServiceFacade {
    private static PegasusSnsServiceFacade instance;
    @Autowired
    private QQService qqService;
    @Autowired
    private WeiXinService weixinService;
    @Autowired
    private WeiBoService weiboService;
    @Autowired
    private WeChatAppletService weChatAppletService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PegasusSnsServiceFacade getInstance() {
        if (instance != null) {
            return instance;
        }
        Class<PegasusFacadeLock> clazz = PegasusFacadeLock.class;
        synchronized (PegasusFacadeLock.class) {
            if (instance == null) {
                instance = ComponentServiceLoader.getBean(PegasusSnsServiceFacade.class);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public QQUserInfo getQQSimpleUserInfo(String accessToken, String openId, String platform) {
        return this.qqService.getSimpleUserInfo(accessToken, openId, platform);
    }

    public WXUserInfo getWeiXinUserInfo(String code) {
        WXAccessToken accessToken = this.weixinService.getAccessToken(code);
        return this.weixinService.getUserInfo(accessToken.getAccess_token(), accessToken.getOpenid());
    }

    public WBUserInfo getWeiBoUserInfo(String accessToken, String uid) {
        return this.weiboService.getUserInfo(accessToken, uid);
    }

    public WeChatAppletUserInfo getWeChatUserInfo(String rawData, String encryptedData, String iv, String signature, String code) {
        return this.weChatAppletService.getUserInfo(rawData, encryptedData, iv, signature, code);
    }
}

