/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.payment.service.impl;

import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.payment.config.WeiXinConfig;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXOrderQueryResponse;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.weixin.WXUnifiedOrderResponse;
import com.thebeastshop.pegasus.component.adaptor.payment.service.WeiXinPayService;
import com.thebeastshop.pegasus.component.adaptor.sns.config.WeChatAppletConfig;
import com.thebeastshop.pegasus.util.comm.StringUtil;
import com.thebeastshop.support.exception.PlatErrInfo;
import com.thebeastshop.support.exception.PlatInternalException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.MD5SignUtil;
import com.thebeastshop.support.util.XmlUtil;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WeiXinPayServiceImpl
extends BaseService
implements WeiXinPayService {
    private static final String CHARSET = "UTF-8";

    @Override
    public WXUnifiedOrderResponse unifiedOrder(WXUnifiedOrderParams params) {
        WXUnifiedOrderResponse response = new WXUnifiedOrderResponse();
        try {
            WXUnifiedOrderRequest request = params.toRequest();
            request.setAppid(WeiXinConfig.APP_ID);
            request.setMch_id(WeiXinConfig.MCH_ID);
            request.setNonce_str(StringUtil.getRandomString((int)16));
            request.setSign(this.sign(request));
            this.logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u6570\u636e\uff1a" + request.toString());
            String dataStr = HttpUtil.doXmlPost((String)WeiXinConfig.UNIFIED_ORDER_URL, (String)XmlUtil.toXml((Object)request), (String)CHARSET);
            response = (WXUnifiedOrderResponse)XmlUtil.toObject((String)dataStr, WXUnifiedOrderResponse.class);
            this.logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u6570\u636e\uff1a" + response.toString());
        }
        catch (Exception e) {
            throw new UnknownError("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
        if (response.getReturn_code().equals("SUCCESS") && response.getResult_code().equals("SUCCESS")) {
            return response;
        }
        String platErrCode = StringUtils.isNotBlank((String)response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
        String platErrMsg = StringUtils.isNotBlank((String)response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
        throw new PlatInternalException(new PlatErrInfo("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355", platErrCode, platErrMsg));
    }

    @Override
    public WXOrderQueryResponse orderQuery(WXOrderQueryParams params) {
        WXOrderQueryResponse response = new WXOrderQueryResponse();
        try {
            WXOrderQueryRequest request = params.toRequest();
            request.setAppid(WeiXinConfig.APP_ID);
            request.setMch_id(WeiXinConfig.MCH_ID);
            request.setNonce_str(StringUtil.getRandomString((int)16));
            request.setSign(this.sign(request));
            this.logger.info("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8bf7\u6c42\u6570\u636e\uff1a" + request.toString());
            String dataStr = HttpUtil.doXmlPost((String)WeiXinConfig.ORDER_QUERY_URL, (String)XmlUtil.toXml((Object)request), (String)CHARSET);
            response = (WXOrderQueryResponse)XmlUtil.toObject((String)dataStr, WXOrderQueryResponse.class);
            this.logger.info("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u8fd4\u56de\u6570\u636e\uff1a" + response.toString());
        }
        catch (Exception e) {
            throw new UnknownError("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
        if (response.getReturn_code().equals("SUCCESS") && response.getResult_code().equals("SUCCESS")) {
            return response;
        }
        String platErrCode = StringUtils.isNotBlank((String)response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
        String platErrMsg = StringUtils.isNotBlank((String)response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
        throw new PlatInternalException(new PlatErrInfo("\u5fae\u4fe1\u67e5\u8be2\u8ba2\u5355", platErrCode, platErrMsg));
    }

    @Override
    public String sign(Map<String, String> map) {
        try {
            return MD5SignUtil.md5Sign(map, (String)WeiXinConfig.KEY, (String)WeiXinConfig.CHARSET);
        }
        catch (Exception e) {
            throw new WrongArgException("\u5fae\u4fe1\u7b7e\u540d\u51fa\u9519", "map:", map);
        }
    }

    @Override
    public String sign(Object obj) {
        try {
            return MD5SignUtil.md5Sign((Object)obj, (String)WeiXinConfig.KEY, (String)WeiXinConfig.CHARSET);
        }
        catch (Exception e) {
            throw new WrongArgException("\u5fae\u4fe1\u7b7e\u540d\u51fa\u9519", "object:", obj);
        }
    }

    @Override
    public String signPc(Object obj) {
        try {
            return MD5SignUtil.md5Sign((Object)obj, (String)WeiXinConfig.PC_KEY, (String)WeiXinConfig.CHARSET);
        }
        catch (Exception e) {
            throw new WrongArgException("\u5fae\u4fe1\u7b7e\u540d\u51fa\u9519", "object:", obj);
        }
    }

    @Override
    public WXUnifiedOrderResponse weChatAppletUnifiedOrder(WXUnifiedOrderParams params) {
        WXUnifiedOrderResponse response = new WXUnifiedOrderResponse();
        try {
            WXUnifiedOrderRequest request = params.toRequest();
            request.setAppid(WeChatAppletConfig.APP_ID);
            request.setMch_id(WeChatAppletConfig.MCH_ID);
            request.setNonce_str(StringUtil.getRandomString((int)16));
            request.setSign(this.signForWX(request).toUpperCase());
            this.logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u6570\u636e\uff1a" + request.toString());
            String dataStr = HttpUtil.doXmlPost((String)WeiXinConfig.UNIFIED_ORDER_URL, (String)XmlUtil.toXml((Object)request), (String)CHARSET);
            response = (WXUnifiedOrderResponse)XmlUtil.toObject((String)dataStr, WXUnifiedOrderResponse.class);
            this.logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u6570\u636e\uff1a" + response.toString());
        }
        catch (Exception e) {
            throw new UnknownError("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
        if (response.getReturn_code().equals("SUCCESS") && response.getResult_code().equals("SUCCESS")) {
            return response;
        }
        String platErrCode = StringUtils.isNotBlank((String)response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
        String platErrMsg = StringUtils.isNotBlank((String)response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
        throw new PlatInternalException(new PlatErrInfo("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355", platErrCode, platErrMsg));
    }

    @Override
    public WXUnifiedOrderResponse weChatAppletUnifiedOrder(WXUnifiedOrderParams params, Boolean isWebSite) {
        WXUnifiedOrderResponse response = new WXUnifiedOrderResponse();
        try {
            WXUnifiedOrderRequest request = params.toRequest();
            if (isWebSite.booleanValue()) {
                request.setAppid(WeChatAppletConfig.APP_ID2);
            } else {
                request.setAppid(WeChatAppletConfig.APP_ID);
            }
            request.setMch_id(WeChatAppletConfig.MCH_ID);
            request.setNonce_str(StringUtil.getRandomString((int)16));
            request.setSign(this.signForWX(request).toUpperCase());
            this.logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8bf7\u6c42\u6570\u636e\uff1a" + request.toString());
            String dataStr = HttpUtil.doXmlPost((String)WeiXinConfig.UNIFIED_ORDER_URL, (String)XmlUtil.toXml((Object)request), (String)CHARSET);
            response = (WXUnifiedOrderResponse)XmlUtil.toObject((String)dataStr, WXUnifiedOrderResponse.class);
            this.logger.info("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u8fd4\u56de\u6570\u636e\uff1a" + response.toString());
        }
        catch (Exception e) {
            throw new UnknownError("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
        if (response.getReturn_code().equals("SUCCESS") && response.getResult_code().equals("SUCCESS")) {
            return response;
        }
        String platErrCode = StringUtils.isNotBlank((String)response.getErr_code()) ? response.getErr_code() : response.getReturn_code();
        String platErrMsg = StringUtils.isNotBlank((String)response.getErr_code_des()) ? response.getErr_code_des() : response.getReturn_msg();
        throw new PlatInternalException(new PlatErrInfo("\u5fae\u4fe1\u7edf\u4e00\u4e0b\u5355", platErrCode, platErrMsg));
    }

    @Override
    public String signForWX(Map<String, String> map) {
        try {
            return MD5SignUtil.md5Sign(map, (String)WeChatAppletConfig.KEY, (String)WeiXinConfig.CHARSET);
        }
        catch (Exception e) {
            throw new WrongArgException("\u5fae\u4fe1\u7b7e\u540d\u51fa\u9519", "map:", map);
        }
    }

    @Override
    public String signForWX(Object obj) {
        try {
            return MD5SignUtil.md5Sign((Object)obj, (String)WeChatAppletConfig.KEY, (String)WeiXinConfig.CHARSET);
        }
        catch (Exception e) {
            throw new WrongArgException("\u5fae\u4fe1\u7b7e\u540d\u51fa\u9519", "object:", obj);
        }
    }
}

