/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.payment.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.thebeastshop.pegasus.component.adaptor.BaseService;
import com.thebeastshop.pegasus.component.adaptor.payment.config.AlipayConfig;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayCrossBorderMobilePayParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayCrossBorderMobilePayRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayDirectPayParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayDirectPayRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayMobilePayParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayMobilePayRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api1.AlipayRequest_API1;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2.AlipayTradeQueryParams;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2.AlipayTradeQueryRequest;
import com.thebeastshop.pegasus.component.adaptor.payment.domain.alipay.api2.AlipayTradeQueryResponse;
import com.thebeastshop.pegasus.component.adaptor.payment.service.AliPayService;
import com.thebeastshop.support.exception.PlatErrInfo;
import com.thebeastshop.support.exception.PlatInternalException;
import com.thebeastshop.support.exception.WrongArgException;
import com.thebeastshop.support.util.BeanUtil;
import com.thebeastshop.support.util.HttpUtil;
import com.thebeastshop.support.util.JsonUtil;
import com.thebeastshop.support.util.MD5SignUtil;
import com.thebeastshop.support.util.RSASignUtil;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AliPayServiceImpl
extends BaseService
implements AliPayService {
    private <T> T toResponse(String content, Class<T> clazz, String charset) throws Exception {
        String alipaySign;
        Map map = JsonUtil.toMap((String)content);
        Collection values = map.values();
        Map dataMap = (Map)values.iterator().next();
        Object response = BeanUtil.map2Bean((Map)dataMap, clazz);
        String string = alipaySign = map.get("sign") != null ? map.get("sign").toString() : "";
        if (!RSASignUtil.rsaCheckSign((String)JsonUtil.toJson((Map)dataMap), (String)alipaySign, (String)AlipayConfig.ALIPAY_PUBLIC_KEY, (String)charset)) {
            throw new PlatInternalException(new PlatErrInfo("\u652f\u4ed8\u5b9d\u8c03\u7528\u8fd4\u56de:\u7b7e\u540d\u9519\u8bef", "sign", alipaySign));
        }
        return (T)response;
    }

    @Override
    public boolean notifyVerify(String notify_id, boolean isCrossBorder) {
        try {
            this.logger.info("\u9a8c\u8bc1\u662f\u5426\u662f\u652f\u4ed8\u5b9d\u53d1\u6765\u7684\u901a\u77e5\u8bf7\u6c42\u6570\u636e\uff1a" + notify_id);
            String partner = "";
            partner = isCrossBorder ? AlipayConfig.CROSS_BORDER_PARTNER : AlipayConfig.PARTNER;
            HashMap params = Maps.newHashMap();
            params.put("service", "notify_verify");
            params.put("partner", partner);
            params.put("notify_id", notify_id);
            String rt = HttpUtil.doGet((String)AlipayConfig.API_1_0, (Map)params, (String)AlipayConfig.CHARSET);
            if (StringUtils.isNotBlank((String)rt)) {
                return Boolean.valueOf(rt);
            }
        }
        catch (Exception e) {
            this.logger.error("\u9a8c\u8bc1\u662f\u5426\u662f\u652f\u4ed8\u5b9d\u53d1\u6765\u7684\u901a\u77e5\u9519\u8bef! e={}", (Throwable)e);
            throw new UnknownError("\u9a8c\u8bc1\u662f\u5426\u662f\u652f\u4ed8\u5b9d\u53d1\u6765\u7684\u901a\u77e5\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
        return false;
    }

    @Override
    public String mobilePay(AlipayMobilePayParams params) {
        try {
            AlipayMobilePayRequest request = params.toRequest();
            request.setService(AlipayConfig.MOBILE_PAY_SERVICE);
            request.setPartner(AlipayConfig.PARTNER);
            request.setSign(this.sign(request, request.getSign_type(), false));
            this.logger.info("\u652f\u4ed8\u5b9d\u79fb\u52a8\u652f\u4ed8\u8bf7\u6c42\u6570\u636e\uff1a" + ((AlipayRequest_API1)request).toString());
            if (request.getSign_type().equalsIgnoreCase(AlipayConfig.RSA_SIGN_TYPE)) {
                return RSASignUtil.getSignContent((Object)request);
            }
            if (request.getSign_type().equalsIgnoreCase(AlipayConfig.MD5_SIGN_TYPE)) {
                return MD5SignUtil.getSignContent((Object)request);
            }
            throw new WrongArgException("\u8bf7\u8f93\u5165\u6b63\u786e\u7b7e\u540d\u65b9\u5f0f\uff08MD5\u6216\u8005RSA\uff09", "sign_type", (Object)request.getSign_type());
        }
        catch (WrongArgException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownError("\u652f\u4ed8\u5b9d\u79fb\u52a8\u652f\u4ed8\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
    }

    @Override
    public String crossBorderMobilePay(AlipayCrossBorderMobilePayParams params) {
        try {
            AlipayCrossBorderMobilePayRequest request = params.toRequest();
            request.setService(AlipayConfig.MOBILE_PAY_SERVICE);
            request.setPartner(AlipayConfig.CROSS_BORDER_PARTNER);
            request.setSign(this.sign(request, request.getSign_type(), true));
            this.logger.info("\u652f\u4ed8\u5b9d\u56fd\u9645\u79fb\u52a8\u652f\u4ed8\u8bf7\u6c42\u6570\u636e\uff1a" + ((AlipayRequest_API1)request).toString());
            if (request.getSign_type().equalsIgnoreCase(AlipayConfig.RSA_SIGN_TYPE)) {
                return RSASignUtil.getSignContent((Object)request);
            }
            if (request.getSign_type().equalsIgnoreCase(AlipayConfig.MD5_SIGN_TYPE)) {
                return MD5SignUtil.getSignContent((Object)request);
            }
            throw new WrongArgException("\u8bf7\u8f93\u5165\u6b63\u786e\u7b7e\u540d\u65b9\u5f0f\uff08MD5\u6216\u8005RSA\uff09", "sign_type", (Object)request.getSign_type());
        }
        catch (WrongArgException e) {
            throw e;
        }
        catch (Exception e) {
            throw new UnknownError("\u652f\u4ed8\u5b9d\u56fd\u9645\u79fb\u52a8\u652f\u4ed8\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
    }

    @Override
    public String directPay(AlipayDirectPayParams params) {
        try {
            AlipayDirectPayRequest request = params.toRequest();
            request.setService(AlipayConfig.DIRECT_PAY_SERVICE);
            request.setPartner(AlipayConfig.PARTNER);
            request.setSign(this.sign(request, AlipayConfig.MD5_SIGN_TYPE, false));
            this.logger.info("\u652f\u4ed8\u5b9d\u5373\u65f6\u5230\u8d26\u8bf7\u6c42\u6570\u636e\uff1a" + ((AlipayRequest_API1)request).toString());
            String link = AlipayConfig.API_1_0 + HttpUtil.buildQuery((Map)BeanUtil.bean2Map((Object)request), (List)Lists.newArrayList(), (String)request.get_input_charset());
            this.logger.info("\u652f\u4ed8\u5b9d\u5373\u65f6\u5230\u8d26\u8fd4\u56de\u94fe\u63a5\uff1a" + link);
            return link;
        }
        catch (Exception e) {
            throw new UnknownError("\u652f\u4ed8\u5b9d\u5373\u65f6\u5230\u8d26\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
    }

    @Override
    public AlipayTradeQueryResponse tradeQuery(AlipayTradeQueryParams params) {
        try {
            AlipayTradeQueryRequest request = new AlipayTradeQueryRequest();
            request.setApp_id(AlipayConfig.APP_ID);
            request.setMethod(AlipayConfig.TRADE_QUERY_METHOD);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
            request.setTimestamp(df.format(new Date()));
            request.setVersion(AlipayConfig.VERSION);
            request.setBiz_content(JsonUtil.toJson((Object)params));
            request.setSign(this.sign(request, AlipayConfig.RSA_SIGN_TYPE, false));
            this.logger.info("\u652f\u4ed8\u5b9d\u4ea4\u6613\u67e5\u8be2\u8bf7\u6c42\u6570\u636e\uff1a" + request.toString());
            String dataStr = HttpUtil.doFormPost((String)AlipayConfig.API_2_0, (Map)BeanUtil.bean2Map((Object)request), (String)request.getCharset());
            AlipayTradeQueryResponse response = this.toResponse(dataStr, AlipayTradeQueryResponse.class, request.getCharset());
            this.logger.info("\u652f\u4ed8\u5b9d\u4ea4\u6613\u67e5\u8be2\u8fd4\u56de\u6570\u636e\uff1a" + response);
            return response;
        }
        catch (Exception e) {
            throw new UnknownError("\u652f\u4ed8\u5b9d\u4ea4\u6613\u67e5\u8be2\u5f02\u5e38: " + e.getMessage() + " " + e.getStackTrace());
        }
    }

    @Override
    public String sign(Object object, String signType, boolean isCrossBorder) {
        try {
            if (signType.equalsIgnoreCase(AlipayConfig.RSA_SIGN_TYPE)) {
                String private_key = "";
                private_key = isCrossBorder ? AlipayConfig.CROSS_BORDER_PRIVATE_KEY : AlipayConfig.PRIVATE_KEY;
                return RSASignUtil.rsaSign((Object)object, (String)private_key, (String)AlipayConfig.CHARSET);
            }
            if (signType.equalsIgnoreCase(AlipayConfig.MD5_SIGN_TYPE)) {
                Map filterPara = HttpUtil.paraFilter((Map)BeanUtil.bean2Map((Object)object), Arrays.asList("sign", "sign_type"));
                String md5_key = "";
                md5_key = isCrossBorder ? AlipayConfig.CROSS_BORDER_MD5_KEY : AlipayConfig.MD5_KEY;
                return MD5SignUtil.md5Sign((Map)filterPara, (String)md5_key, (String)AlipayConfig.CHARSET, (boolean)false);
            }
        }
        catch (Exception e) {
            throw new WrongArgException("\u652f\u4ed8\u5b9d\u7b7e\u540d\u51fa\u9519", "object:", object);
        }
        return "";
    }
}

