/*
 * Decompiled with CFR 0.152.
 */
package com.thebeastshop.pegasus.component.adaptor.luhan.service.impl;

import com.alibaba.dubbo.common.utils.StringUtils;
import com.google.common.collect.Lists;
import com.thebeastshop.pegasus.component.adaptor.luhan.LuhanOrderVO;
import com.thebeastshop.pegasus.component.adaptor.luhan.dao.mapper.LuhanOrderMapper;
import com.thebeastshop.pegasus.component.adaptor.luhan.model.LuhanOrder;
import com.thebeastshop.pegasus.component.adaptor.luhan.model.LuhanOrderExample;
import com.thebeastshop.pegasus.component.adaptor.luhan.service.LuhanOrderService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import com.thebeastshop.pegasus.util.comm.NumberUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LuhanOrderServiceImpl
implements LuhanOrderService {
    @Autowired
    private LuhanOrderMapper mapper;

    @Override
    public List<LuhanOrderVO> findLuhanOrder(LuhanOrderVO luhanOrderVO) {
        LuhanOrderExample example = new LuhanOrderExample();
        LuhanOrderExample.Criteria criteria = example.createCriteria().andMemberIdEqualTo(luhanOrderVO.getMemberId());
        criteria.andStatusEqualTo(1);
        if (StringUtils.isNotEmpty((String)luhanOrderVO.getOrderCode())) {
            criteria.andOrderCodeEqualTo(luhanOrderVO.getOrderCode());
        }
        if (!NumberUtil.isNullOrZero((Number)luhanOrderVO.getSpvId())) {
            criteria.andSpvIdEqualTo(luhanOrderVO.getSpvId());
        }
        List<LuhanOrder> list = this.mapper.selectByExample(example);
        return BeanUtil.buildListFrom(list, LuhanOrderVO.class);
    }

    @Override
    public boolean saveOrder(List<LuhanOrderVO> luhanOrderVOs) {
        if (CollectionUtils.isNotEmpty(luhanOrderVOs)) {
            List saves = BeanUtil.buildListFrom(luhanOrderVOs, LuhanOrder.class);
            for (LuhanOrder luhanOrder : saves) {
                luhanOrder.setModifyTime(new Date());
                luhanOrder.setCreateTime(new Date());
                luhanOrder.setStatus(1);
                this.mapper.insert(luhanOrder);
            }
        }
        return true;
    }

    @Override
    public boolean saveOrder(LuhanOrderVO luhanOrderVO) {
        return this.saveOrder(Lists.newArrayList((Object[])new LuhanOrderVO[]{luhanOrderVO}));
    }

    @Override
    public boolean delOrder(String orderCode) {
        LuhanOrder record = new LuhanOrder();
        record.setStatus(2);
        record.setModifyTime(new Date());
        LuhanOrderExample example = new LuhanOrderExample();
        example.createCriteria().andOrderCodeEqualTo(orderCode);
        int i = this.mapper.updateByExampleSelective(record, example);
        return true;
    }
}

