package com.thebeastshop.pegasus.component.shop.service.impl;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.apache.ibatis.annotations.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.thebeastshop.pegasus.component.shop.dao.ShopEntryDao;
import com.thebeastshop.pegasus.component.shop.domain.BubbleVo;
import com.thebeastshop.pegasus.component.shop.domain.OpShopOperation;
import com.thebeastshop.pegasus.component.shop.domain.ShopEntry;
import com.thebeastshop.pegasus.component.shop.domain.ShopEntryExample;
import com.thebeastshop.pegasus.component.shop.domain.ShopVo;
import com.thebeastshop.pegasus.component.shop.service.ShopEntryService;
import com.thebeastshop.pegasus.component.support.ComponentServiceLoader;

@Service
public class ShopEntryServiceImpl implements ShopEntryService {
	@Autowired
	private ShopEntryDao dao;
	protected Logger logger = LoggerFactory.getLogger(this.getClass());

	protected ShopEntryService service = ComponentServiceLoader
			.getBean(ShopEntryService.class);


	@Override
	public int countByExample(ShopEntryExample example) {
		// TODO Auto-generated method stub
		return dao.countByExample(example);
	}

	@Override
	public int deleteByExample(ShopEntryExample example) {
		// TODO Auto-generated method stub
		return dao.deleteByExample(example);
	}

	@Override
	public int deleteByPrimaryKey(Long id) {
		// TODO Auto-generated method stub
		return dao.deleteByPrimaryKey(id);
	}

	@Override
	public int insert(ShopEntry record) {
		// TODO Auto-generated method stub
		return dao.insert(record);
	}

	@Override
	public int insertSelective(ShopEntry record) {
		// TODO Auto-generated method stub
		return dao.insert(record);
	}

	@Override
	public List<ShopEntry> selectByExample(ShopEntryExample example) {
		// TODO Auto-generated method stub
		return dao.selectByExample(example);
	}

	@Override
	public ShopEntry selectByPrimaryKey(Long id) {
		// TODO Auto-generated method stub
		return dao.selectByPrimaryKey(id);
	}

	@Override
	public int updateByExampleSelective(ShopEntry record,
			ShopEntryExample example) {
		// TODO Auto-generated method stub
		return dao.updateByExampleSelective(record, example);
	}

	@Override
	public int updateByExample(ShopEntry record, ShopEntryExample example) {
		// TODO Auto-generated method stub
		return dao.updateByExample(record, example);
	}

	@Override
	public int updateByPrimaryKeySelective(ShopEntry record) {
		// TODO Auto-generated method stub
		return dao.updateByPrimaryKeySelective(record);
	}

	@Override
	public int updateByPrimaryKey(ShopEntry record) {
		// TODO Auto-generated method stub
		return dao.updateByPrimaryKey(record);
	}

	public ShopEntryDao getDao() {
		return dao;
	}

	public void setDao(ShopEntryDao dao) {
		this.dao = dao;
	}

	@Override
	public List<ShopVo> findOperationListByCond(ShopVo cond) {
		// TODO Auto-generated method stub
		
		return dao.findOperationListByCond(cond);
	}

	@Override
	public List<BubbleVo> findBubbleByCond(BubbleVo cond) {
		// TODO Auto-generated method stub
		return dao.findBubbleByCond(cond);
	}


	@Override
	public List<OpShopOperation> findOperationByCond(OpShopOperation cond) {
		// TODO Auto-generated method stub
//		try {
//			// 查找所有预发布内容
//			OpShopOperation cond0 = new OpShopOperation();
//			cond0.setState(3);
//			List<OpShopOperation> ops = new ArrayList<OpShopOperation>();
//			ops = service.findOperationByCond(cond0);
//			if (null != ops && ops.size() > 0) {
//				for (OpShopOperation op : ops) {
//					Date pre = op.getPublishTime();
//					Date cur = Calendar.getInstance().getTime();
//					if (pre.before(cur)) {
//						// 查找线上数据并下线
//						OpShopOperation cond1 = new OpShopOperation();
//						cond1.setState(1);
//						cond1.setShopId(op.getShopId());
//						List<OpShopOperation> records = new ArrayList<OpShopOperation>();
//						records = service.findOperationByCond(cond1);
//						if (null != records && records.size() > 0) {
//							for (OpShopOperation record : records) {
//								record.setState(2);
//								service.operationUpdateByPrimaryKeySelective(record);
//							}
//						}
//						// 预发上线
//						op.setState(1);
//						service.operationUpdateByPrimaryKeySelective(op);
//					}
//				}
//			}
//		} catch (Exception e) {
//			logger.info("预约发布异常 e:{}", e);
//		}
		return dao.findOperationByCond(cond);
	}
	
	@Override
	public int operationUpdateByPrimaryKeySelective(OpShopOperation record) {
		// TODO Auto-generated method stub
		return dao.operationUpdateByPrimaryKeySelective(record);
	}
	
	
}