package com.thebeastshop.pegasus.component.redenvelope.util.redenvelope;

import com.google.common.collect.Lists;


import java.util.*;

/**
 * Created by feilong.gao on 2017/3/31.
 */
public class PutTogetherUtil {

    private ElementPool pool;
    private Map<Integer,RedElement> eleMap = new HashMap<>();
    private List<Integer> priceArray = Lists.newArrayList();
    private Map<Integer,Map<Integer,Integer>> matchTable = new HashMap<>();
    // 最大差距
    private int maxDisparity;

    private Integer maxPrice;
    private Integer minPrice;
    private Integer averagePrice;

    public void init(ElementPool elementPool){
        if(null != elementPool){
            if(null == pool){
                pool = elementPool;
            }
            for(RedElement ele :pool.getEles()){
                eleMap.put(ele.getValue(),ele);
                priceArray.add(ele.getValue());
            }
            this.getMatchTable();
            this.getMaxDisparity();
        }

    }

    /**
     * 获取计算表
     */
    private void getMatchTable(){
        matchTable.clear();
        for(Integer i :priceArray){
            for(int j = 1 ; j<priceArray.size();j++){
                Integer a = i-priceArray.get(j);
                Map<Integer,Integer> map = null;
                if(matchTable.containsKey(a)){
                    map = matchTable.get(a);
                    map.put(i,priceArray.get(j));
                }else{
                    map = new HashMap<>();
                    map.put(i,priceArray.get(j));
                    matchTable.put(a,map);
                }
            }
        }
    }

    /**
     * 计算最大差距
     */
    private void getMaxDisparity(){
        this.maxDisparity = priceArray.get(0)-priceArray.get(priceArray.size()-1);
    }

    public ElementPool putTogether(ElementPool elementPool, Integer totalPrice){
        if(null == pool){
            init(elementPool);
        }
        int average = totalPrice/elementPool.getTotalCount();
        List<Integer> gtAverage = Lists.newArrayList();
        List<Integer> ltAverage = Lists.newArrayList();
        for(Integer price : priceArray){
            if(price>average){
                gtAverage.add(price);
            }else{
                ltAverage.add(price);
            }
        }

        //随机个数
        int randomNum= elementPool.getTotalCount()/2;
        int gtRandomNum = randomNum;
        int ltRandomNum = randomNum;

        if(randomNum*2 !=elementPool.getTotalCount()){
            ltRandomNum += 1;
        }
        List<Integer> gtList = Lists.newArrayList();
        List<Integer> ltList = Lists.newArrayList();
        Boolean flag = true;
        do{
            gtList = this.getRandomList(gtAverage,gtRandomNum);
            ltList = this.getRandomList(ltAverage,ltRandomNum);
            int cutSum = getSum(gtList)+getSum(ltList);
            Integer dValue = cutSum - totalPrice;
            if(cutSum>totalPrice){
                gtRandomNum -=1;
                ltRandomNum +=1;
            }else if(cutSum<totalPrice){
                gtRandomNum +=1;
                ltRandomNum -=1;
            }else{
                flag = true;
            }

            if(flag && matchTable.containsKey(dValue)){
                Map<Integer,Integer> m = matchTable.get(dValue);
                for(int i =0 ;i<gtList.size() ;i++){
                    if(m.containsKey(gtList.get(i))){
                        gtList.set(i,m.get(gtList.get(i)));
                        flag = false;
                        break;
                    }

                }
                for(int i =0 ;i<ltList.size() ;i++){
                    if(m.containsKey(ltList.get(i))){
                        ltList.set(i,m.get(ltList.get(i)));
                        flag = false;
                        break;
                    }

                }
                cutSum = getSum(gtList)+getSum(ltList);
                if(cutSum != totalPrice){
                    flag = true;
                }
            }
        }while (flag);

        Map<Integer,Integer> eleNumMap = new HashMap<>();
        for(Integer i : gtList){
            if(eleNumMap.containsKey(i)){
                eleNumMap.put(i,eleNumMap.get(i)+1);
            }else{
                eleNumMap.put(i,1);
            }
        }
        for(Integer i : ltList){
            if(eleNumMap.containsKey(i)){
                eleNumMap.put(i,eleNumMap.get(i)+1);
            }else{
                eleNumMap.put(i,1);
            }
        }

        List<RedElement> redEles = Lists.newArrayList();
        for(Map.Entry<Integer,Integer> entery : eleNumMap.entrySet()){
            RedElement redElement = eleMap.get(entery.getKey());
            redElement.setNum(entery.getValue());
            redEles.add(new RedElement(redElement));
        }
        ElementPool result = new ElementPool(pool);
        result.setEles(redEles);

        return result;
    }


    private Integer getSum(List<Integer> list){
        Integer sum = 0;
        for(Integer i : list){
            sum +=i;
        }
        return  sum;
    }

    private List<Integer> getRandomList(List<Integer> sources,Integer count){
        List<Integer> targets = new ArrayList<>();
        int i = sources.size();
        for(int j = 0 ;j<count;j++){
            int idx = new Random().nextInt(i);
            targets.add(sources.get(idx));
        }
        return targets;
    }


}
