package com.thebeastshop.pegasus.component.redenvelope.service.impl;

import com.alibaba.fastjson.JSON;
import com.thebeastshop.pegasus.component.redenvelope.dao.mapper.RedEnvelopeMapper;
import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelopeExample;
import com.thebeastshop.pegasus.component.redenvelope.service.RedEnvelopeService;
import com.thebeastshop.pegasus.component.support.service.RedisService;
import com.thebeastshop.pegasus.util.comm.BeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;

/**
 * Created by feilong.gao on 2016/12/20.
 */
@Service
public class RedEnvelopeServiceImpl implements RedEnvelopeService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private RedEnvelopeMapper mapper;
	@Autowired
	private RedisService redisService;
	private String RED_ENVELOPE_ACTIVITY_KEY = "RE_ACTIVITY_";

	@Override
	@Transactional
	public boolean updateStock(Long id) {
		logger.info("更新分享活动id[{}]的红包库存", id);
		RedEnvelope old = mapper.selectByPrimaryKey(id);
		if (old != null && old.getReleasedCount() < old.getReAmount()) {
			logger.info("id[{}]库存记录：{}", JSON.toJSONString(old));
			RedEnvelope upd = new RedEnvelope();
			upd.setReleasedCount(old.getReleasedCount() + 1);
			upd.setModifyTime(new Date());
			RedEnvelopeExample redEnvelopeExample = new RedEnvelopeExample();
			redEnvelopeExample.createCriteria().andIdEqualTo(id)
					.andReleasedCountLessThan(old.getReAmount());
			int num = mapper.updateByExampleSelective(upd, redEnvelopeExample);
			logger.info("更新id[{}]的红包库存，结果：", num == 1);
			if (num == 1) {
				return true;
			}
		} else {
			logger.warn("id[{}]库存记录为空", id);
		}
		return false;
	}

	@Override
	public RedEnvelopeDTO getRedEnveloper(Long id) {
		logger.info("获取id[{}]的活动详情", id);
		RedEnvelopeDTO result = null;
//		result = redisService.get(getRedEnveloperRedisKey(id.toString()),
//				RedEnvelopeDTO.class);
		if (result == null) {
			RedEnvelope old = mapper.selectByPrimaryKey(id);
			result = BeanUtil.buildFrom(old, RedEnvelopeDTO.class);
//			redisService.set(getRedEnveloperRedisKey(id.toString()), result);
		}
		logger.info("id[{}]的活动记录信息：{}", id, JSON.toJSONString(result));
		return result;
	}

	/**
	 * 获取红包分享活动rediskey
	 * 
	 * @param shareId
	 * @return
	 */
	private String getRedEnveloperRedisKey(String shareId) {
		return RED_ENVELOPE_ACTIVITY_KEY + shareId;
	}

	/**
	 * 根据订单号查询红包记录
	 * 
	 * @param orderId
	 * @return
	 */
	public RedEnvelopeDTO getRedEnvelopeByOrder(String orderId,String memberCode) {
		logger.info(" 根据订单号orderId[{}]查询红包记录", orderId);
		
		RedEnvelopeDTO result = new RedEnvelopeDTO();
		RedEnvelopeExample example = new RedEnvelopeExample();
		example.createCriteria().andBindIdEqualTo(orderId).andMemberCodeEqualTo(memberCode);
		List<RedEnvelope> reds = mapper.selectByExample(example);
		if (null!=reds && reds.size()>0){
			result = BeanUtil.buildFrom(reds.get(0), RedEnvelopeDTO.class);
		}else {
			result=null;
		}
		
		return result;
	}
	@Override
	public int newRedEnvelopeByOrder(RedEnvelope record) {
		// TODO Auto-generated method stub
		return mapper.insert(record);
	}
}
