package com.thebeastshop.pegasus.component.redenvelope.service;

import com.thebeastshop.pegasus.component.redenvelope.domain.RedEnvelopeDTO;
import com.thebeastshop.pegasus.component.redenvelope.model.RedEnvelope;

/**
 * 红包服务接口
 * Created by feilong.gao on 2016/12/20.
 */
public interface RedEnvelopeService {


    /**
     * 更新红包库存数量。
     * 扣库存成功返回true or false
     * @return
     */
    public boolean updateStock(Long id);


    /**
     * 获取红包活动信息
     * @param id
     * @return
     */
    public RedEnvelopeDTO getRedEnveloper(Long id);

    
    /**
     * 根据订单号查询红包记录
     * @param orderId
     * @return
     */
    public RedEnvelopeDTO getRedEnvelopeByOrder(String orderId,String memberCode);

    /**
     * 新增一个分享红包
     * @param record
     * @return
     */
	int newRedEnvelopeByOrder(RedEnvelope record);

}
