package com.thebeastshop.pegasus.component.price;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import com.thebeastshop.cart.resp.TempCartProductPack;
import com.thebeastshop.member.vo.MemberVO;

import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.cart.ProductPack;;
import com.thebeastshop.support.AccessWay;

/**
 * 计算商品价格的上下文。 仅用来展示时用此实现。
 *
 * @author Liang Wenjian
 */
public class PriceCalculateContextForTempCartProduct implements PriceCalculateContext {

	private MemberVO member;
	private AccessWay accessWay;
	private Channel channel;
	private Map<ProductPack, BigDecimal> packAndOriginalPrice;
	private List<TempCartProductPack> validPacks;

	public PriceCalculateContextForTempCartProduct() {
		super();
	}

	public List<TempCartProductPack> getValidPacks() {
		return validPacks;
	}

	public void setValidPacks(List<TempCartProductPack> validPacks) {
		this.validPacks = validPacks;
	}

	@Override
	public MemberVO getMember() {
		return member;
	}

	public void setMember(final MemberVO member) {
		this.member = member;
	}

	@Override
	public AccessWay getAccessWay() {
		return accessWay;
	}

	public void setAccessWay(final AccessWay accessWay) {
		this.accessWay = accessWay;
	}

	@Override
	public Map<ProductPack, BigDecimal> getPackAndOriginalPrice() {
		return packAndOriginalPrice;
	}

	public void setPackAndOriginalPrice(final Map<ProductPack, BigDecimal> packAndOriginalPrice) {
		this.packAndOriginalPrice = packAndOriginalPrice;
	}

	@Override
	public Channel getChannel() {
		return channel;
	}
}
