package com.thebeastshop.pegasus.component.price;

import java.math.BigDecimal;
import java.util.Map;

import com.thebeastshop.member.vo.MemberVO;
import com.thebeastshop.pegasus.component.channel.Channel;
import com.thebeastshop.pegasus.component.coupon.domain.Coupon;
import com.thebeastshop.cart.ProductPack;;
import com.thebeastshop.support.AccessWay;

/**
 * 计算商品价格的上下文。 仅用来搞订单时用此实现。里面包含用户已选的优惠券。
 *
 * @author Liang Wenjian
 */
public class PriceCalculateContextForOrder implements PriceCalculateContext {

	private MemberVO member;
	private AccessWay accessWay;
	private Channel channel;
	private Map<ProductPack, BigDecimal> packAndOriginalPrice;
	private Coupon coupon;

	public PriceCalculateContextForOrder() {
		super();
	}

	public Coupon getCoupon() {
		return coupon;
	}

	public void setCoupon(final Coupon coupon) {
		this.coupon = coupon;
	}

	public MemberVO getMember() {
		return member;
	}

	public void setMember(MemberVO member) {
		this.member = member;
	}

	public AccessWay getAccessWay() {
		return accessWay;
	}

	public void setAccessWay(AccessWay accessWay) {
		this.accessWay = accessWay;
	}

	public Channel getChannel() {
		return channel;
	}

	public void setChannel(Channel channel) {
		this.channel = channel;
	}

	public Map<ProductPack, BigDecimal> getPackAndOriginalPrice() {
		return packAndOriginalPrice;
	}

	public void setPackAndOriginalPrice(Map<ProductPack, BigDecimal> packAndOriginalPrice) {
		this.packAndOriginalPrice = packAndOriginalPrice;
	}

}
